/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CompilerMojo
extends AbstractCompilerMojo {
    @Parameter(defaultValue="${project.compileSourceRoots}", readonly=true, required=true)
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.artifact}", readonly=true, required=true)
    private Artifact projectArtifact;
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private Set<String> excludes = new HashSet<String>();
    @Parameter(defaultValue="${project.build.directory}/generated-sources/annotations")
    private File generatedSourcesDirectory;
    @Parameter(property="maven.main.skip")
    private boolean skipMain;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    private List<String> classpathElements;
    private List<String> modulepathElements;

    @Override
    protected List<String> getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    @Override
    protected List<String> getClasspathElements() {
        return this.classpathElements;
    }

    @Override
    protected List<String> getModulepathElements() {
        return this.modulepathElements;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void execute() throws MojoExecutionException, CompilationFailureException {
        if (this.skipMain) {
            this.getLog().info((CharSequence)"Not compiling main sources");
            return;
        }
        super.execute();
        if (this.outputDirectory.isDirectory()) {
            this.projectArtifact.setFile(this.outputDirectory);
        }
    }

    @Override
    protected void preparePaths(Set<File> sourceFiles) {
        assert (this.compilePath != null);
        boolean hasModuleDescriptor = false;
        for (File sourceFile : sourceFiles) {
            if (!"module-info.java".equals(sourceFile.getName())) continue;
            hasModuleDescriptor = true;
            break;
        }
        if (hasModuleDescriptor) {
            this.modulepathElements = this.compilePath;
            this.classpathElements = Collections.emptyList();
        } else {
            this.classpathElements = this.compilePath;
            this.modulepathElements = Collections.emptyList();
        }
        this.getLog().debug((CharSequence)("classpathElements: " + this.getClasspathElements()));
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.includes, this.excludes);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner;
        String defaultIncludePattern = "**/*" + (inputFileEnding.startsWith(".") ? "" : ".") + inputFileEnding;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            this.includes = Collections.singleton(defaultIncludePattern);
            scanner = new SimpleSourceInclusionScanner(this.includes, Collections.emptySet());
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add(defaultIncludePattern);
            }
            scanner = new SimpleSourceInclusionScanner(this.includes, this.excludes);
        }
        return scanner;
    }

    @Override
    protected String getSource() {
        return this.source;
    }

    @Override
    protected String getTarget() {
        return this.target;
    }

    @Override
    protected String getRelease() {
        return this.release;
    }

    @Override
    protected String getCompilerArgument() {
        return this.compilerArgument;
    }

    @Override
    protected Map<String, String> getCompilerArguments() {
        return this.compilerArguments;
    }

    @Override
    protected File getGeneratedSourcesDirectory() {
        return this.generatedSourcesDirectory;
    }
}

