package pt.digitalis.dif.content.model.dao.auto;


import java.sql.Blob;
import java.util.Date;
import java.util.List;

import pt.digitalis.dif.content.model.data.ContentItem;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class ContentItem.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.content.model.data.ContentItem
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoContentItemDAO extends IHibernateDAO<ContentItem> {

    /**
     * Obtains a new DataSet for the ContentItem entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ContentItem> getContentItemDataSet();

	/**
	 * Persist a ContentItem object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ContentItem transientInstance);

	/**
	 * Updates a modified ContentItem in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ContentItem instance);

	/**
	 * Attach an unmodified ContentItem instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ContentItem instance);

	/**
	 * Removes a ContentItem instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ContentItem persistentInstance);

	/**
	 * Merge a ContentItem instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ContentItem merge(ContentItem detachedInstance);

	/**
	 * Finds a ContentItem instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ContentItem findById( java.lang.String id);

	/**
	 * Gets a {@link List} of all ContentItem instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<ContentItem> findAll();


	/**
	 * Gets a {@link List} of all ContentItem instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<ContentItem> findByFieldParcial(ContentItem.Fields field, String value);

	/**
	 * Gets a {@link List} of all ContentItem instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<ContentItem> findByName(String name);

	/**
	 * Gets a {@link List} of all ContentItem instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<ContentItem> findByDescription(String description);

	/**
	 * Gets a {@link List} of all ContentItem instances
	 * in the persistence layer than match the creationDate attribute with the given value
	 *
	 * @param creationDate to match
	 * @return the {@link List} of instances
	 */
    public List<ContentItem> findByCreationDate(Date creationDate);

	/**
	 * Gets a {@link List} of all ContentItem instances
	 * in the persistence layer than match the creatorId attribute with the given value
	 *
	 * @param creatorId to match
	 * @return the {@link List} of instances
	 */
    public List<ContentItem> findByCreatorId(String creatorId);

	/**
	 * Gets a {@link List} of all ContentItem instances
	 * in the persistence layer than match the content attribute with the given value
	 *
	 * @param content to match
	 * @return the {@link List} of instances
	 */
    public List<ContentItem> findByContent(Blob content);
}
