/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.content;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.exception.ConstraintViolationException;
import pt.digitalis.dif.content.model.ContentManagerFactory;
import pt.digitalis.dif.content.model.IDocumentsService;
import pt.digitalis.dif.content.model.data.ContentItem;
import pt.digitalis.dif.content.model.data.ContentItemAcl;
import pt.digitalis.dif.content.model.data.Node;
import pt.digitalis.dif.content.model.data.NodeAcl;
import pt.digitalis.dif.content.model.impl.DocumentsServiceImpl;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.utils.extensions.cms.ACLEntry;
import pt.digitalis.dif.utils.extensions.cms.AbstractContentManager;
import pt.digitalis.dif.utils.extensions.cms.exception.ContentItemNotFoundException;
import pt.digitalis.dif.utils.extensions.cms.exception.ContentItemWithDuplicateNameAndParentNodeException;
import pt.digitalis.dif.utils.extensions.cms.exception.ContentManagerException;
import pt.digitalis.dif.utils.extensions.cms.exception.InvalidParentNodeException;
import pt.digitalis.dif.utils.extensions.cms.exception.NodeNotFoundException;
import pt.digitalis.dif.utils.extensions.cms.exception.NodeWithDuplicatePathException;
import pt.digitalis.dif.utils.extensions.cms.exception.NodeWithNodesException;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentManagerDBImpl
extends AbstractContentManager {
    private IDocumentsService documentsService = null;

    public void beginTransaction() {
        this.getSession().beginTransaction();
    }

    public void commitTransaction() {
        this.getSession().getTransaction().commit();
    }

    private List<pt.digitalis.dif.utils.extensions.cms.ContentItem> convertContentItemListToDIFObject(List<ContentItem> contentItemList, IDIFUser user) {
        ArrayList<pt.digitalis.dif.utils.extensions.cms.ContentItem> contentItemConvertedList = new ArrayList<pt.digitalis.dif.utils.extensions.cms.ContentItem>();
        if (contentItemList == null) {
            return null;
        }
        for (ContentItem contentItem : contentItemList) {
            contentItemConvertedList.add(this.convertContentItemToDIFObject(contentItem, user));
        }
        return contentItemConvertedList;
    }

    private ContentItem convertContentItemToDBObject(pt.digitalis.dif.utils.extensions.cms.ContentItem contentItem) throws ContentManagerException {
        Node node;
        try {
            node = (Node)this.getDocumentsService().getNodeDataSet().get(contentItem.getParentNodeId().toString());
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
        ContentItem convertedContentItem = new ContentItem(node, contentItem.getName(), contentItem.getCreationDate(), contentItem.getCreatorID());
        String contentToCreate = contentItem.getContent();
        if (contentToCreate == null) {
            contentToCreate = "";
        }
        Blob blob = ContentManagerFactory.getLobHelper().createBlob(contentToCreate.getBytes());
        convertedContentItem.setContent(blob);
        convertedContentItem.setDescription(contentItem.getDescription());
        convertedContentItem.setId(contentItem.getId());
        return convertedContentItem;
    }

    private pt.digitalis.dif.utils.extensions.cms.ContentItem convertContentItemToDIFObject(ContentItem contentItem, IDIFUser user) {
        pt.digitalis.dif.utils.extensions.cms.ContentItem convertedContentItem = new pt.digitalis.dif.utils.extensions.cms.ContentItem(contentItem.getNode().getId(), contentItem.getName(), contentItem.getCreatorId(), user);
        convertedContentItem.setId(contentItem.getId());
        if (contentItem.getContent() != null) {
            try {
                InputStream inputStream = contentItem.getContent().getBinaryStream();
                convertedContentItem.setContent(IOUtils.toString((InputStream)inputStream));
            }
            catch (SQLException e) {
                convertedContentItem.setContent("");
                e.printStackTrace();
            }
            catch (IOException e) {
                convertedContentItem.setContent("");
                e.printStackTrace();
            }
        } else {
            convertedContentItem.setContent("");
        }
        convertedContentItem.setCreationDate(contentItem.getCreationDate());
        convertedContentItem.setDescription(contentItem.getDescription());
        return convertedContentItem;
    }

    private String convertContentListToString(List<ContentItem> contentList) {
        if (contentList == null || contentList.size() == 0) {
            return null;
        }
        StringBuffer toRetrun = new StringBuffer();
        for (ContentItem item : contentList) {
            toRetrun.append(",'" + item.getId() + "'");
        }
        return toRetrun.substring(1);
    }

    private List<ACLEntry> convertFromContentItemAclToDIFAcl(List<ContentItemAcl> implList) {
        ArrayList<ACLEntry> convertedList = new ArrayList<ACLEntry>();
        for (ContentItemAcl contentItemAcl : implList) {
            ACLEntry entry = new ACLEntry();
            entry.setGroupID(contentItemAcl.getGroupId());
            entry.setUserID(contentItemAcl.getUserId());
            convertedList.add(entry);
        }
        return convertedList;
    }

    private List<ACLEntry> convertFromNodeAclToDIFAcl(List<NodeAcl> implList) {
        ArrayList<ACLEntry> convertedList = new ArrayList<ACLEntry>();
        for (NodeAcl nodeAcl : implList) {
            ACLEntry entry = new ACLEntry();
            entry.setGroupID(nodeAcl.getGroupId());
            entry.setUserID(nodeAcl.getUserId());
            convertedList.add(entry);
        }
        return convertedList;
    }

    private String convertIdListToString(List<BigDecimal> decimalList) {
        if (decimalList == null || decimalList.size() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (BigDecimal decimal : decimalList) {
            buffer.append("," + decimal);
        }
        return buffer.substring(1);
    }

    private List<pt.digitalis.dif.utils.extensions.cms.Node> convertNodeListToDIFObjects(List<Node> nodeList, IDIFUser user) {
        ArrayList<pt.digitalis.dif.utils.extensions.cms.Node> nodeConvertedList = new ArrayList<pt.digitalis.dif.utils.extensions.cms.Node>();
        if (nodeList != null) {
            for (Node node : nodeList) {
                nodeConvertedList.add(this.convertNodeToDIFObject(node, user));
            }
        }
        return nodeConvertedList;
    }

    private Node convertNodeToDBObject(pt.digitalis.dif.utils.extensions.cms.Node node) {
        Node convertedNode = new Node(node.getName(), node.getCreationDate(), node.getCreatorID(), Character.valueOf(node.isPublic() ? (char)'S' : 'N'));
        convertedNode.setId(node.getId());
        convertedNode.setDescription(node.getDescription());
        convertedNode.setFullPath(node.getFullPathName());
        convertedNode.setParentNodeId(node.getParentNodeId());
        return convertedNode;
    }

    private pt.digitalis.dif.utils.extensions.cms.Node convertNodeToDIFObject(Node node, IDIFUser user) {
        pt.digitalis.dif.utils.extensions.cms.Node convertedNode = new pt.digitalis.dif.utils.extensions.cms.Node(node.getParentNodeId(), node.getName(), node.getCreatorId(), user);
        convertedNode.setCreationDate(node.getCreationDate());
        convertedNode.setDescription(node.getDescription());
        convertedNode.setFullPathName(node.getFullPath());
        convertedNode.setId(node.getId());
        convertedNode.setPublic(node.getIsPublic().charValue() == 'S');
        return convertedNode;
    }

    protected boolean deleteContentInRepository(String contentId, IDIFUser user) throws ContentManagerException {
        try {
            this.getDocumentsService().getContentItemDataSet().delete(contentId.toString());
            return true;
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected boolean deleteNodeInRepository(Long nodeId, IDIFUser user, boolean cascadeDelete) throws ContentManagerException {
        boolean result = false;
        Session session = this.getDocumentsService().getNodeDAO().getSession();
        boolean doCommit = false;
        boolean wasActive = session.getTransaction().isActive();
        if (!wasActive) {
            session.beginTransaction();
        }
        try {
            Node node = (Node)this.getDocumentsService().getNodeDataSet().get(nodeId.toString());
            if (!cascadeDelete) {
                List childNodes = this.getNodesByParentNodeNoPermissions(node.getId(), user);
                if (childNodes.size() > 0) {
                    throw new NodeWithNodesException(node.getId());
                }
                result = this.deleteNodeInRepository(node);
            } else {
                SQLQuery query = this.getSession().createSQLQuery(" SELECT id  FROM cms.node  START WITH id = ?  CONNECT BY PRIOR id = parent_node_id");
                query.setLong(0, node.getId().longValue());
                List nodeIdList = query.list();
                if (nodeIdList.size() == 0) {
                    boolean bl = true;
                    return bl;
                }
                String nodeListStr = this.convertIdListToString(nodeIdList);
                Query queryContents = this.getDocumentsService().getContentItemDataSet().query();
                queryContents.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Node.class.getSimpleName() + ".id")), FilterType.IN, CollectionUtils.listToCommaSeparatedString((List)nodeIdList)));
                String contentListStr = this.convertContentListToString(queryContents.asList());
                if (contentListStr != null) {
                    this.getSession().createQuery("DELETE FROM " + ContentItemAcl.class.getSimpleName() + " WHERE " + StringUtils.toLowerFirstChar((String)ContentItem.class.getSimpleName()) + " in (" + contentListStr + ")").executeUpdate();
                    this.getSession().createQuery("DELETE FROM " + ContentItem.class.getSimpleName() + " WHERE " + "id" + " in (" + contentListStr + ")").executeUpdate();
                }
                this.getSession().createQuery("DELETE FROM " + NodeAcl.class.getSimpleName() + " WHERE " + StringUtils.toLowerFirstChar((String)Node.class.getSimpleName()) + " in (" + nodeListStr + ")").executeUpdate();
                this.getSession().createQuery("DELETE FROM " + Node.class.getSimpleName() + " WHERE " + "id" + " in (" + nodeListStr + ")").executeUpdate();
            }
            doCommit = true;
            result = true;
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
        finally {
            if (!wasActive) {
                if (doCommit) {
                    session.getTransaction().commit();
                } else {
                    session.getTransaction().rollback();
                }
            }
        }
        return result;
    }

    private boolean deleteNodeInRepository(Node node) throws ContentManagerException {
        try {
            this.getDocumentsService().getNodeDataSet().delete(node.getId().toString());
            return true;
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<pt.digitalis.dif.utils.extensions.cms.ContentItem> getContentByDescriptionInRepository(String description, IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getContentItemDataSet().query();
            query.addFilter(new Filter("description".toString(), FilterType.EQUALS, description));
            return this.convertContentItemListToDIFObject(query.asList(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected pt.digitalis.dif.utils.extensions.cms.ContentItem getContentByIdInRepository(String id, IDIFUser user) throws ContentManagerException {
        try {
            ContentItem contentItemDB = (ContentItem)this.getDocumentsService().getContentItemDataSet().get(id.toString());
            if (contentItemDB == null) {
                throw new ContentItemNotFoundException(id);
            }
            return this.convertContentItemToDIFObject(contentItemDB, user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected pt.digitalis.dif.utils.extensions.cms.ContentItem getContentByIdNoPermissionsInRepository(String id, IDIFUser user) throws ContentManagerException {
        try {
            ContentItem contentItem = (ContentItem)this.getDocumentsService().getContentItemDataSet().get(id.toString());
            if (contentItem == null) {
                throw new ContentItemNotFoundException(id);
            }
            return this.convertContentItemToDIFObject(contentItem, user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<pt.digitalis.dif.utils.extensions.cms.ContentItem> getContentByNameInRepository(String name, IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getContentItemDataSet().query();
            query.addFilter(new Filter("name".toString(), FilterType.EQUALS, name));
            return this.convertContentItemListToDIFObject(query.asList(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<pt.digitalis.dif.utils.extensions.cms.ContentItem> getContentByParentNodeInRepository(Long nodeId, IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getContentItemDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Node.class.getSimpleName() + ".id")), FilterType.EQUALS, nodeId.toString()));
            return this.convertContentItemListToDIFObject(query.asList(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<pt.digitalis.dif.utils.extensions.cms.ContentItem> getContentByParentNodeNoPermissions(Long nodeId, IDIFUser user) throws ContentManagerException {
        this.getNodeByIdNoPermissions(nodeId, user);
        Query query = this.getDocumentsService().getContentItemDataSet().query();
        try {
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Node.class.getSimpleName() + ".id")), FilterType.EQUALS, nodeId.toString()));
            return this.convertContentItemListToDIFObject(query.asList(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected pt.digitalis.dif.utils.extensions.cms.ContentItem getContentFromNodePathByNameRepository(String nodeFullPath, String name, IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getContentItemDataSet().query();
            query.addFilter(new Filter("name".toString(), FilterType.EQUALS, name));
            query.addFilter(new Filter("fullPath".toString(), FilterType.EQUALS, nodeFullPath));
            return this.convertContentItemToDIFObject((ContentItem)query.singleValue(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<ACLEntry> getContentItemACLInRepository(String contentId) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getContentItemAclDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(ContentItem.class.getSimpleName() + ".id")), FilterType.EQUALS, contentId.toString()));
            return this.convertFromContentItemAclToDIFAcl(query.asList());
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    private IDocumentsService getDocumentsService() {
        if (this.documentsService == null) {
            this.documentsService = new DocumentsServiceImpl();
        }
        return this.documentsService;
    }

    protected List<ACLEntry> getNodeACLInRepository(Long nodeId) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getNodeAclDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Node.class.getSimpleName() + ".id")), FilterType.EQUALS, nodeId.toString()));
            return this.convertFromNodeAclToDIFAcl(query.asList());
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected pt.digitalis.dif.utils.extensions.cms.Node getNodeByIdInRepository(Long id, IDIFUser user) throws ContentManagerException {
        try {
            Node node = (Node)this.getDocumentsService().getNodeDataSet().get(id.toString());
            if (node == null) {
                throw new NodeNotFoundException(id);
            }
            return this.convertNodeToDIFObject(node, user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected pt.digitalis.dif.utils.extensions.cms.Node getNodeByIdNoPermissionsInRepository(Long id, IDIFUser user) throws ContentManagerException {
        try {
            Node node = (Node)this.getDocumentsService().getNodeDataSet().get(id.toString());
            if (node == null) {
                throw new NodeNotFoundException(id);
            }
            return this.convertNodeToDIFObject(node, user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected pt.digitalis.dif.utils.extensions.cms.Node getNodeByPathInRespository(String fullPath, IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getNodeDataSet().query();
            query.addFilter(new Filter("fullPath".toString(), FilterType.EQUALS, fullPath));
            Node node = (Node)query.singleValue();
            if (node == null) {
                throw new NodeNotFoundException("Node not found with path: " + fullPath);
            }
            return this.convertNodeToDIFObject(node, user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<pt.digitalis.dif.utils.extensions.cms.Node> getNodesByDescriptionInRepository(String description, IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getNodeDataSet().query();
            query.addFilter(new Filter("description".toString(), FilterType.EQUALS, description));
            return this.convertNodeListToDIFObjects(query.asList(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<pt.digitalis.dif.utils.extensions.cms.Node> getNodesByDescriptionInRepository(String basePathToSearch, String description, IDIFUser user) throws ContentManagerException {
        try {
            if (basePathToSearch == null || basePathToSearch.length() == 0 || basePathToSearch.equals(Character.valueOf(SEPARATOR))) {
                return this.getNodesByDescriptionInRepository(description, user);
            }
            Query query = this.getDocumentsService().getNodeDataSet().query();
            query.addFilter(new Filter("description".toString(), FilterType.EQUALS, description));
            query.addFilter(new Filter("fullPath".toString(), FilterType.LESSER_OR_EQUALS_THAN, basePathToSearch));
            return this.convertNodeListToDIFObjects(query.asList(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<pt.digitalis.dif.utils.extensions.cms.Node> getNodesByNameInRepository(String name, IDIFUser user) throws ContentManagerException {
        Query query = this.getDocumentsService().getNodeDataSet().query();
        try {
            query.addFilter(new Filter("name".toString(), FilterType.EQUALS, name));
            return this.convertNodeListToDIFObjects(query.asList(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<pt.digitalis.dif.utils.extensions.cms.Node> getNodesByNameInRepository(String basePathToSearch, String name, IDIFUser user) throws ContentManagerException {
        if (basePathToSearch == null || basePathToSearch.length() == 0 || basePathToSearch.equals(Character.valueOf(SEPARATOR))) {
            return this.getNodesByNameInRepository(name, user);
        }
        Query query = this.getDocumentsService().getNodeDataSet().query();
        try {
            query.addFilter(new Filter("name".toString(), FilterType.EQUALS, name));
            query.addFilter(new Filter("fullPath".toString(), FilterType.LESSER_OR_EQUALS_THAN, basePathToSearch));
            return this.convertNodeListToDIFObjects(query.asList(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<pt.digitalis.dif.utils.extensions.cms.Node> getNodesByParentNodeInRepository(Long nodeId, IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getNodeDataSet().query();
            query.addFilter(new Filter("parentNodeId".toString(), FilterType.EQUALS, nodeId.toString()));
            return this.convertNodeListToDIFObjects(query.asList(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<pt.digitalis.dif.utils.extensions.cms.Node> getNodesByParentNodeNoPermissionsInRepository(Long nodeId, IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getNodeDataSet().query();
            query.addFilter(new Filter("parentNodeId".toString(), FilterType.EQUALS, nodeId.toString()));
            return this.convertNodeListToDIFObjects(query.asList(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected String getParentFullPathInRepository(pt.digitalis.dif.utils.extensions.cms.Node node) throws ContentManagerException {
        try {
            Node parentNodeDb = (Node)this.getDocumentsService().getNodeDataSet().get(node.getParentNodeId().toString());
            if (parentNodeDb == null) {
                throw new InvalidParentNodeException(node.getId());
            }
            return parentNodeDb.getFullPath();
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected List<pt.digitalis.dif.utils.extensions.cms.Node> getRootNodesInRepository(IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getNodeDataSet().query();
            query.addFilter(new Filter("parentNodeId".toString(), FilterType.IS_NULL));
            return this.convertNodeListToDIFObjects(query.asList(), user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    private Session getSession() {
        return this.getDocumentsService().getContentItemAclDAO().getSession();
    }

    protected boolean grantContentAccessToGroupInRepository(pt.digitalis.dif.utils.extensions.cms.ContentItem contentItemParam, String groupId) throws ContentManagerException {
        HashSet<String> groups = new HashSet<String>();
        groups.add(groupId);
        if (!this.hasContentAccessGroupsInRepository(contentItemParam.getId(), groups)) {
            ContentItem contentItem = this.convertContentItemToDBObject(contentItemParam);
            ContentItemAcl contentItemAcl = new ContentItemAcl();
            contentItemAcl.setContentItem(contentItem);
            contentItemAcl.setGroupId(groupId);
            try {
                this.getDocumentsService().getContentItemAclDataSet().insert((IBeanAttributes)contentItemAcl);
            }
            catch (DataSetException e) {
                throw new ContentManagerException((Exception)((Object)e));
            }
        }
        return true;
    }

    protected boolean grantContentAccessToUserInRepository(pt.digitalis.dif.utils.extensions.cms.ContentItem contentItemParam, IDIFUser user) throws ContentManagerException {
        if (!this.hasContentAccessUserInRepository(contentItemParam.getId(), user)) {
            ContentItem contentItem = this.convertContentItemToDBObject(contentItemParam);
            ContentItemAcl contentItemAcl = new ContentItemAcl();
            contentItemAcl.setContentItem(contentItem);
            contentItemAcl.setUserId(user.getID());
            try {
                this.getDocumentsService().getContentItemAclDataSet().insert((IBeanAttributes)contentItemAcl);
            }
            catch (DataSetException e) {
                throw new ContentManagerException((Exception)((Object)e));
            }
        }
        return true;
    }

    protected boolean grantNodeAccessToGroupInRepository(pt.digitalis.dif.utils.extensions.cms.Node nodeParam, String groupId) throws ContentManagerException {
        Node node = this.convertNodeToDBObject(nodeParam);
        NodeAcl nodeAcl = new NodeAcl();
        nodeAcl.setNode(node);
        nodeAcl.setGroupId(groupId);
        nodeAcl.setUserId(null);
        try {
            this.getDocumentsService().getNodeAclDataSet().insert((IBeanAttributes)nodeAcl);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
        return true;
    }

    protected boolean grantNodeAccessToUserInRepository(pt.digitalis.dif.utils.extensions.cms.Node nodeParam, IDIFUser user) throws ContentManagerException {
        Node node = this.convertNodeToDBObject(nodeParam);
        NodeAcl nodeAcl = new NodeAcl();
        nodeAcl.setNode(node);
        nodeAcl.setUserId(user.getID());
        try {
            this.getDocumentsService().getNodeAclDataSet().insert((IBeanAttributes)nodeAcl);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
        return true;
    }

    protected boolean hasContentAccessGroupsInRepository(String contentId, Set<String> groups) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getContentItemAclDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(pt.digitalis.dif.utils.extensions.cms.ContentItem.class.getSimpleName() + ".id")), FilterType.EQUALS, contentId.toString()));
            query.addFilter(new Filter("groupId".toString(), FilterType.IN, CollectionUtils.setToCommaSeparatedString(groups)));
            long result = query.count();
            return result > 0L;
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected boolean hasContentAccessUserInRepository(String contentId, IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getContentItemAclDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(pt.digitalis.dif.utils.extensions.cms.ContentItem.class.getSimpleName() + ".id")), FilterType.EQUALS, contentId.toString()));
            query.addFilter(new Filter("userId".toString(), FilterType.EQUALS, user.getID()));
            return query.count() > 0L;
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected boolean hasNodeAccessGroupsInRepository(Long nodeId, Set<String> groups) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getNodeAclDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Node.class.getSimpleName() + ".id")), FilterType.EQUALS, nodeId.toString()));
            query.addFilter(new Filter("groupId".toString(), FilterType.IN, CollectionUtils.setToCommaSeparatedString(groups)));
            return query.count() > 0L;
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected boolean hasNodeAccessUserInRespository(Long nodeId, IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getNodeAclDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Node.class.getSimpleName() + ".id")), FilterType.EQUALS, nodeId.toString()));
            query.addFilter(new Filter("userId".toString(), FilterType.EQUALS, user.getID()));
            return query.count() > 0L;
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected pt.digitalis.dif.utils.extensions.cms.ContentItem mergeContentInRepository(pt.digitalis.dif.utils.extensions.cms.ContentItem contentParam, IDIFUser user) throws ContentManagerException {
        ContentItem content = this.convertContentItemToDBObject(contentParam);
        pt.digitalis.dif.utils.extensions.cms.ContentItem result = null;
        try {
            Session session = this.getDocumentsService().getNodeDAO().getSession();
            boolean wasActive = session.getTransaction().isActive();
            if (!wasActive) {
                session.beginTransaction();
            }
            session.saveOrUpdate((Object)content);
            content = this.getDocumentsService().getContentItemDAO().findById(content.getId());
            result = this.convertContentItemToDIFObject(content, user);
            if (!wasActive) {
                session.getTransaction().commit();
            }
            return result;
        }
        catch (ConstraintViolationException e) {
            throw new ContentItemWithDuplicateNameAndParentNodeException((Exception)((Object)e));
        }
    }

    protected pt.digitalis.dif.utils.extensions.cms.Node mergeNodeInRepository(pt.digitalis.dif.utils.extensions.cms.Node nodeParam, IDIFUser user) {
        Node node = this.convertNodeToDBObject(nodeParam);
        Session session = this.getDocumentsService().getNodeDAO().getSession();
        boolean wasActive = session.getTransaction().isActive();
        if (!wasActive) {
            session.beginTransaction();
        }
        node = this.getDocumentsService().getNodeDAO().merge(node);
        if (!wasActive) {
            session.getTransaction().commit();
        }
        return this.convertNodeToDIFObject(node, user);
    }

    protected pt.digitalis.dif.utils.extensions.cms.ContentItem moveContentInRepository(pt.digitalis.dif.utils.extensions.cms.ContentItem contentParam, pt.digitalis.dif.utils.extensions.cms.Node nodeParam, IDIFUser user) throws ContentManagerException {
        try {
            ContentItem currentContent = (ContentItem)this.getDocumentsService().getContentItemDataSet().get(contentParam.getId().toString());
            if (currentContent == null) {
                throw new ContentItemNotFoundException();
            }
            currentContent.setNode(this.convertNodeToDBObject(nodeParam));
            this.getDocumentsService().getContentItemDataSet().update((IBeanAttributes)currentContent);
            return this.convertContentItemToDIFObject(currentContent, user);
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected pt.digitalis.dif.utils.extensions.cms.Node moveNodeInRepository(pt.digitalis.dif.utils.extensions.cms.Node nodeParam, IDIFUser user) {
        Node node = this.convertNodeToDBObject(nodeParam);
        Session session = this.getDocumentsService().getNodeDAO().getSession();
        boolean wasActive = session.getTransaction().isActive();
        if (!wasActive) {
            session.beginTransaction();
        }
        this.getDocumentsService().getNodeDAO().merge(node);
        if (!wasActive) {
            session.getTransaction().commit();
        }
        return this.convertNodeToDIFObject(node, user);
    }

    protected boolean nodeExistsInRepository(Long id, IDIFUser user) throws ContentManagerException {
        try {
            Node node = (Node)this.getDocumentsService().getNodeDataSet().get(id.toString());
            return node != null;
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected pt.digitalis.dif.utils.extensions.cms.ContentItem persistContentInRepository(pt.digitalis.dif.utils.extensions.cms.ContentItem content, IDIFUser user) throws ContentManagerException {
        pt.digitalis.dif.utils.extensions.cms.ContentItem result = null;
        boolean isActive = this.getDocumentsService().getContentItemDAO().getSession().getTransaction().isActive();
        if (!isActive) {
            this.getDocumentsService().getContentItemDAO().getSession().beginTransaction();
        }
        try {
            ContentItem contentItemDb = this.convertContentItemToDBObject(content);
            contentItemDb.setCreationDate(new Date());
            contentItemDb.setCreatorId(user.getID());
            this.getDocumentsService().getContentItemDAO().persist(contentItemDb);
            contentItemDb = this.getDocumentsService().getContentItemDAO().findById(contentItemDb.getId());
            result = this.convertContentItemToDIFObject(contentItemDb, user);
            if (!isActive) {
                this.getDocumentsService().getContentItemDAO().getSession().getTransaction().commit();
            }
            return result;
        }
        catch (ConstraintViolationException e) {
            if (!isActive) {
                this.getDocumentsService().getContentItemDAO().getSession().getTransaction().rollback();
            }
            throw new ContentItemWithDuplicateNameAndParentNodeException((Exception)((Object)e));
        }
    }

    protected pt.digitalis.dif.utils.extensions.cms.Node persistNodeInRepository(pt.digitalis.dif.utils.extensions.cms.Node node, IDIFUser user) throws ContentManagerException {
        try {
            Node nodeDb = this.convertNodeToDBObject(node);
            nodeDb.setCreationDate(new Date());
            nodeDb.setCreatorId(user.getID());
            nodeDb = (Node)this.getDocumentsService().getNodeDataSet().insert((IBeanAttributes)nodeDb);
            NodeAcl nodeAcl = new NodeAcl();
            nodeAcl.setUserId(node.getCreatorID());
            nodeAcl.setNode(nodeDb);
            this.getDocumentsService().getNodeAclDataSet().insert((IBeanAttributes)nodeAcl);
            return this.convertNodeToDIFObject(nodeDb, user);
        }
        catch (ConstraintViolationException e) {
            throw new NodeWithDuplicatePathException((Exception)((Object)e));
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected boolean revokeContentAccessToGroupInRepository(String contentId, String groupId) {
        boolean wasActive = this.getSession().getTransaction().isActive();
        if (!wasActive) {
            this.getSession().beginTransaction();
        }
        try {
            Query query = this.getDocumentsService().getContentItemAclDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(ContentItem.class.getSimpleName() + ".id")), FilterType.EQUALS, contentId.toString()));
            query.addFilter(new Filter("groupId".toString(), FilterType.EQUALS, groupId));
            for (ContentItemAcl toDelete : query.asList()) {
                this.getDocumentsService().getContentItemAclDataSet().delete(toDelete.getId().toString());
            }
            if (!wasActive) {
                this.getSession().getTransaction().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!wasActive) {
                this.getSession().getTransaction().rollback();
            }
            return false;
        }
        return true;
    }

    protected boolean revokeContentAccessToUserInRepository(String contentId, IDIFUser user) {
        boolean wasActive = this.getSession().getTransaction().isActive();
        if (!wasActive) {
            this.getSession().beginTransaction();
        }
        try {
            Query query = this.getDocumentsService().getContentItemAclDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(ContentItem.class.getSimpleName() + ".id")), FilterType.EQUALS, contentId.toString()));
            query.addFilter(new Filter("userId".toString(), FilterType.EQUALS, user.getID()));
            for (ContentItemAcl toDelete : query.asList()) {
                this.getDocumentsService().getContentItemAclDataSet().delete(toDelete.getId().toString());
            }
            if (!wasActive) {
                this.getSession().getTransaction().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!wasActive) {
                this.getSession().getTransaction().rollback();
            }
            return false;
        }
        return true;
    }

    protected boolean revokeNodeAccessToGroupInRepository(Long nodeId, String groupId) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getNodeAclDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Node.class.getSimpleName() + ".id")), FilterType.EQUALS, nodeId.toString()));
            query.addFilter(new Filter("groupId".toString(), FilterType.EQUALS, groupId.toString()));
            for (NodeAcl toDelete : query.asList()) {
                this.getDocumentsService().getNodeAclDataSet().delete(toDelete.getId().toString());
            }
            return true;
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    protected boolean revokeNodeAccessToUserInRepository(Long nodeId, IDIFUser user) throws ContentManagerException {
        try {
            Query query = this.getDocumentsService().getNodeAclDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Node.class.getSimpleName() + ".id")), FilterType.EQUALS, nodeId.toString()));
            query.addFilter(new Filter("userId".toString(), FilterType.EQUALS, user.getID()));
            for (NodeAcl toDelete : query.asList()) {
                this.getDocumentsService().getNodeAclDataSet().delete(toDelete.getId().toString());
            }
            return true;
        }
        catch (DataSetException e) {
            throw new ContentManagerException((Exception)((Object)e));
        }
    }

    public void rollbackTransaction() {
        this.getSession().getTransaction().commit();
    }
}

