/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.content.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.content.model.ContentManagerFactory;
import pt.digitalis.dif.content.model.dao.auto.IAutoNodeAclDAO;
import pt.digitalis.dif.content.model.data.NodeAcl;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoNodeAclDAOImpl
implements IAutoNodeAclDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<NodeAcl> getNodeAclDataSet() {
        return new HibernateDataSet(NodeAcl.class, (IHibernateDAO)this, NodeAcl.getPKFieldListAsString());
    }

    public Session getSession() {
        return ContentManagerFactory.getSession();
    }

    @Override
    public void persist(NodeAcl transientInstance) {
        this.logger.debug((Object)"persisting NodeAcl instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(NodeAcl instance) {
        this.logger.debug((Object)"attaching dirty NodeAcl instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(NodeAcl instance) {
        this.logger.debug((Object)"attaching clean NodeAcl instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(NodeAcl persistentInstance) {
        this.logger.debug((Object)"deleting NodeAcl instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public NodeAcl merge(NodeAcl detachedInstance) {
        this.logger.debug((Object)"merging NodeAcl instance");
        NodeAcl result = (NodeAcl)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public NodeAcl findById(Long id) {
        this.logger.debug((Object)("getting NodeAcl instance with id: " + id));
        NodeAcl instance = (NodeAcl)this.getSession().get(NodeAcl.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<NodeAcl> findAll() {
        List<NodeAcl> instances = new ArrayList();
        this.logger.debug((Object)"getting all NodeAcl instances");
        instances = this.getSession().createCriteria(NodeAcl.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<NodeAcl> findByExample(NodeAcl instance) {
        this.logger.debug((Object)"finding NodeAcl instance by example");
        List results = this.getSession().createCriteria(NodeAcl.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<NodeAcl> findByFieldParcial(NodeAcl.Fields field, String value) {
        this.logger.debug((Object)("finding NodeAcl instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(NodeAcl.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<NodeAcl> findByUserId(String userId) {
        NodeAcl instance = new NodeAcl();
        instance.setUserId(userId);
        return this.findByExample(instance);
    }

    @Override
    public List<NodeAcl> findByGroupId(String groupId) {
        NodeAcl instance = new NodeAcl();
        instance.setGroupId(groupId);
        return this.findByExample(instance);
    }
}

