/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.impl;

import java.util.List;
import pt.digitalis.dif.dem.managers.impl.model.dao.IAclDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.AutoAclDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Acl;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclDAOImpl
extends AutoAclDAOImpl
implements IAclDAO {
    @Override
    public boolean deleteAllGroupAccess(String groupID) {
        List<Acl> entries = this.findByGroupId(groupID);
        for (Acl entry : entries) {
            this.delete(entry);
        }
        return entries.size() > 0;
    }

    @Override
    public boolean deleteAllUserAccess(String userID) {
        List<Acl> entries = this.findByUserId(userID);
        for (Acl entry : entries) {
            this.delete(entry);
        }
        return entries.size() > 0;
    }

    @Override
    public boolean deleteGroupAccess(String groupID, String entityType, String entityID) throws DataSetException {
        Acl group = new Acl();
        group.setGroupId(groupID);
        group.setEntityType(entityType);
        group.setEntityId(entityID);
        Query query = this.getAclDataSet().query();
        query = query.addFilter(new Filter("groupId".toString(), FilterType.EQUALS, groupID.toString()));
        query = query.addFilter(new Filter("entityType".toString(), FilterType.EQUALS, entityType.toString()));
        query = query.addFilter(new Filter("entityId".toString(), FilterType.EQUALS, entityID.toString()));
        List entries = query.asList();
        for (Acl entry : entries) {
            if (!"S".equals(entry.getIsDefault())) {
                this.delete(entry);
                continue;
            }
            entry.setIsEnabled("N");
            this.getSession().save((Object)entry);
        }
        return entries.size() > 0;
    }

    @Override
    public boolean deletePublicAccess(String entityType, String entityID) {
        String hqlDelete = "delete " + Acl.class.getCanonicalName() + " acl where acl." + "publicAccess" + " = 'S' and acl." + "entityId" + " = :entityID and acl." + "entityType" + " = :entityType and acl." + "isDefault" + " = 'N'";
        org.hibernate.Query query = this.getSession().createQuery(hqlDelete);
        query.setString("entityID", entityID);
        query.setString("entityType", entityType);
        int deletedEntities = query.executeUpdate();
        Acl publicAccess = new Acl();
        publicAccess.setIsDefault("S");
        publicAccess.setEntityType(entityType);
        publicAccess.setEntityId(entityID);
        List<Acl> entries = this.findByExample(publicAccess);
        int updatedEntities = 0;
        for (Acl entry : entries) {
            entry.setIsEnabled("N");
            this.getSession().save((Object)entry);
            ++updatedEntities;
        }
        return deletedEntities > 0 || updatedEntities > 0;
    }

    @Override
    public boolean deleteUserAccess(String userID, String entityType, String entityID) throws DataSetException {
        Query query = this.getAclDataSet().query();
        query = query.addFilter(new Filter("userId".toString(), FilterType.EQUALS, userID.toString()));
        query = query.addFilter(new Filter("entityType".toString(), FilterType.EQUALS, entityType.toString()));
        query = query.addFilter(new Filter("entityId".toString(), FilterType.EQUALS, entityID.toString()));
        List entries = query.asList();
        for (Acl entry : entries) {
            if (!"S".equals(entry.getIsDefault())) {
                this.delete(entry);
                continue;
            }
            entry.setIsEnabled("N");
            this.getSession().save((Object)entry);
        }
        return entries.size() > 0;
    }

    @Override
    public List<Acl> getAcl(Acl acl) throws DataSetException {
        Query query = this.getAclDataSet().query();
        if (acl.getUserId() != null) {
            query = query.addFilter(new Filter("userId".toString(), FilterType.EQUALS, acl.getUserId()));
        }
        if (acl.getEntityType() != null) {
            query = query.addFilter(new Filter("entityType".toString(), FilterType.EQUALS, acl.getEntityType()));
        }
        if (acl.getEntityId() != null) {
            query = query.addFilter(new Filter("entityId".toString(), FilterType.EQUALS, acl.getEntityId()));
        }
        if (acl.getGroupId() != null) {
            query = query.addFilter(new Filter("groupId".toString(), FilterType.EQUALS, acl.getGroupId()));
        }
        if (acl.getIsDefault() != null) {
            query = query.addFilter(new Filter("isDefault".toString(), FilterType.EQUALS, acl.getIsDefault()));
        }
        if (acl.getIsEnabled() != null) {
            query = query.addFilter(new Filter("isEnabled".toString(), FilterType.EQUALS, acl.getIsEnabled()));
        }
        if (acl.getPublicAccess() != null) {
            query = query.addFilter(new Filter("publicAccess".toString(), FilterType.EQUALS, acl.getPublicAccess()));
        }
        return query.asList();
    }

    @Override
    public Acl getAclByGroup(String groupId, String entityType, String entityID) throws DataSetException {
        Query query = this.getAclDataSet().query();
        query = query.addFilter(new Filter("groupId".toString(), FilterType.EQUALS, groupId.toString()));
        query = entityType != null ? query.addFilter(new Filter("entityType".toString(), FilterType.EQUALS, entityType.toString())) : query.addFilter(new Filter("entityType".toString(), FilterType.IS_NULL));
        query = entityID != null ? query.addFilter(new Filter("entityId".toString(), FilterType.EQUALS, entityID.toString())) : query.addFilter(new Filter("entityId".toString(), FilterType.IS_NULL));
        return (Acl)query.singleValue();
    }

    @Override
    public Acl getAclByPublic(String entityType, String entityID) throws DataSetException {
        Query query = this.getAclDataSet().query();
        query = query.addFilter(new Filter("publicAccess".toString(), FilterType.EQUALS, "S"));
        query = entityType != null ? query.addFilter(new Filter("entityType".toString(), FilterType.EQUALS, entityType.toString())) : query.addFilter(new Filter("entityType".toString(), FilterType.IS_NULL));
        query = entityID != null ? query.addFilter(new Filter("entityId".toString(), FilterType.EQUALS, entityID.toString())) : query.addFilter(new Filter("entityId".toString(), FilterType.IS_NULL));
        return (Acl)query.singleValue();
    }

    @Override
    public Acl getAclByUser(String userId, String entityType, String entityID) throws DataSetException {
        Query query = this.getAclDataSet().query();
        query = query.addFilter(new Filter("userId".toString(), FilterType.EQUALS, userId.toString()));
        query = entityType != null ? query.addFilter(new Filter("entityType".toString(), FilterType.EQUALS, entityType.toString())) : query.addFilter(new Filter("entityType".toString(), FilterType.IS_NULL));
        query = entityID != null ? query.addFilter(new Filter("entityId".toString(), FilterType.EQUALS, entityID.toString())) : query.addFilter(new Filter("entityId".toString(), FilterType.IS_NULL));
        return (Acl)query.singleValue();
    }
}

