package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.IPersistentActionsService;
import pt.digitalis.dif.dem.managers.impl.model.dao.IPersistentActionDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.PersistentActionDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.PersistentAction;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class PersistentActionsServiceImpl implements IPersistentActionsService {

	/**
	 * Obtains a new PersistentAction DAO
	 *
	 * @return A new IPersistentActionDAO
	 */
    public IPersistentActionDAO getPersistentActionDAO() {
    	return new PersistentActionDAOImpl();
    }

    /**
     * Obtains a new DataSet for the PersistentAction entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<PersistentAction> getPersistentActionDataSet() {
        return new HibernateDataSet<PersistentAction>(PersistentAction.class, new PersistentActionDAOImpl(),
                PersistentAction.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == PersistentAction.class)
            return getPersistentActionDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(PersistentAction.class.getSimpleName()))
            return getPersistentActionDataSet();

        return null;
    }
}