/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.utils.logging;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import pt.digitalis.dif.dem.managers.impl.model.IAuditService;
import pt.digitalis.dif.dem.managers.impl.model.data.AuditLog;
import pt.digitalis.dif.dem.managers.impl.model.data.AuditLogDetail;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.hibernate.AuditDetail;
import pt.digitalis.dif.model.hibernate.IAuditingLogger;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditingLoggerDBImplementation
implements IAuditingLogger {
    private static List<String> tablesNotToLOG = new ArrayList<String>();

    public void logDelete(String entityName, String entityID, List<AuditDetail> details, String userName, String appName) throws Exception {
        this.logEntry(Character.valueOf('D'), entityName, entityID, details, userName, appName);
    }

    protected void logEntry(Character operation, String entityName, String entityID, List<AuditDetail> details, String userName, String appName) throws DataSetException {
        if (!tablesNotToLOG.contains(entityName)) {
            userName = StringUtils.nvl((String)userName, (String)"\u00abNo user logged\u00bb");
            appName = StringUtils.nvl((String)appName, (String)"\u00abUndetermined\u00bb");
            DIFLogger.getLogger().trace((Object)("Delete record of " + entityName + " issued by: " + userName + " (using \"" + appName + "\")"));
            IAuditService auditDB = (IAuditService)DIFIoCRegistry.getRegistry().getImplementation(IAuditService.class);
            AuditLog log = new AuditLog();
            log.setApp(appName);
            log.setEntityName(entityName);
            log.setInstanceId(entityID);
            log.setOperation(operation);
            log.setOperationDate(new Timestamp(new Date().getTime()));
            log.setUserid(userName);
            log = (AuditLog)auditDB.getAuditLogDataSet().insert((IBeanAttributes)log);
            for (AuditDetail detail : details) {
                AuditLogDetail logdetail = new AuditLogDetail();
                logdetail.setAuditLog(log);
                logdetail.setColumnName(detail.getFieldName());
                logdetail.setPreviousValue(detail.getPreviousValue());
                logdetail.setNewValue(detail.getNewValue());
                auditDB.getAuditLogDetailDataSet().insert((IBeanAttributes)logdetail);
            }
        }
    }

    public void logInsert(String entityName, String entityID, List<AuditDetail> details, String userName, String appName) throws Exception {
        this.logEntry(Character.valueOf('C'), entityName, entityID, details, userName, appName);
    }

    public void logUpdate(String entityName, String entityID, List<AuditDetail> details, String userName, String appName) throws Exception {
        this.logEntry(Character.valueOf('U'), entityName, entityID, details, userName, appName);
    }

    static {
        tablesNotToLOG.add(AuditLog.class.getSimpleName());
        tablesNotToLOG.add(AuditLogDetail.class.getSimpleName());
    }
}

