package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.Users;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoUsersDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Users.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Users
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoUsersDAOImpl implements IAutoUsersDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Users entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Users> getUsersDataSet()
    {
        return new HibernateDataSet<Users>(Users.class, this, Users.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoUsersDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Users object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Users transientInstance) {
        logger.debug("persisting Users instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Users in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Users instance) {
        logger.debug("attaching dirty Users instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Users instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Users instance) {
        logger.debug("attaching clean Users instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Users instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Users persistentInstance) {
        logger.debug("deleting Users instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Users instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Users merge(Users detachedInstance) {
        logger.debug("merging Users instance");
        Users result = (Users) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Users instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Users findById( java.lang.String id) {
        logger.debug("getting Users instance with id: " + id);
        Users instance = (Users) getSession()
                .get(Users.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Users instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Users> findAll() {

 		List<Users> instances = new ArrayList<Users>();
		logger.debug("getting all Users instances");
        instances = getSession().createCriteria(Users.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Users>) instances;
    }


	/**
	 * Gets a {@link List} of all Users instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Users> findByExample(Users instance) {
        logger.debug("finding Users instance by example");
        List<Users> results = (List<Users>) getSession()
                .createCriteria(Users.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Users instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Users> findByFieldParcial(Users.Fields field, String value) {
        logger.debug("finding Users instance by parcial value: "+field+" like "+value);
        List<Users> results = (List<Users>) getSession()
                .createCriteria(Users.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all Users instances
	 * in the persistence layer than match the email attribute with the given value
	 *
	 * @param email to match
	 * @return the {@link List} of instances
	 */
    public List<Users> findByEmail(String email) {
        Users instance = new Users();

        instance.setEmail(email);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Users instances
	 * in the persistence layer than match the enabled attribute with the given value
	 *
	 * @param enabled to match
	 * @return the {@link List} of instances
	 */
    public List<Users> findByEnabled(boolean enabled) {
        Users instance = new Users();

        instance.setEnabled(enabled);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Users instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<Users> findByName(String name) {
        Users instance = new Users();

        instance.setName(name);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Users instances
	 * in the persistence layer than match the password attribute with the given value
	 *
	 * @param password to match
	 * @return the {@link List} of instances
	 */
    public List<Users> findByPassword(String password) {
        Users instance = new Users();

        instance.setPassword(password);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Users instances
	 * in the persistence layer than match the defaultUser attribute with the given value
	 *
	 * @param defaultUser to match
	 * @return the {@link List} of instances
	 */
    public List<Users> findByDefaultUser(boolean defaultUser) {
        Users instance = new Users();

        instance.setDefaultUser(defaultUser);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Users instances
	 * in the persistence layer than match the nick attribute with the given value
	 *
	 * @param nick to match
	 * @return the {@link List} of instances
	 */
    public List<Users> findByNick(String nick) {
        Users instance = new Users();

        instance.setNick(nick);

        return findByExample(instance);
    }

}

