/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.managers.impl;

import java.util.List;

import org.hibernate.cfg.Configuration;

import pt.digitalis.dif.controller.security.managers.IAuthorizationManager;
import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.ecommerce.IECommerce;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.utils.AbstractModelManager;
import pt.digitalis.dif.startup.DIFGeneralConfigurationParameters;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Dec 19, 2013
 */
public class DIFRepositoryDBModelManager extends AbstractModelManager {

    /** the model identifier */
    public static String MODEL_ID = "DIF";

    /**  */
    private Boolean enabled = null;

    /**
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#getConfiguration()
     */
    @Override
    public Configuration getConfiguration()
    {
        return DIFRepositoryFactory.getConfiguration();
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#getFactoryName()
     */
    @Override
    public String getFactoryName()
    {
        return DIFRepositoryFactory.SESSION_FACTORY_NAME;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IModelManager#getSchema()
     */
    public String getSchema()
    {
        return "DIF";
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IModelManager#isEnabled()
     */
    @Override
    protected boolean isEnabledInternal() throws InternalFrameworkException
    {
        boolean hibernateConnectionConfigured = initializeWithDefaultApplicationConfiguration();

        if (this.enabled == null)
        {
            IAuthorizationManager authorizationManager = DIFIoCRegistry.getRegistry()
                    .getImplementation(IAuthorizationManager.class, "Database");
            IMessageManager messageManager = DIFIoCRegistry.getRegistry().getImplementation(IMessageManager.class,
                    "Database");
            IIdentityManager identityManager = DIFIoCRegistry.getRegistry().getImplementation(IIdentityManager.class,
                    "Database");
            @SuppressWarnings("rawtypes")
            List<IECommerce> eCommerce = DIFIoCRegistry.getRegistry().getImplementations(IECommerce.class);

            String poolsPersistConfig = DIFGeneralConfigurationParameters.getInstance().getPersistPools();
            boolean poolsDatabasePersistance = "Y".equalsIgnoreCase(poolsPersistConfig)
                    || ("D".equalsIgnoreCase(poolsPersistConfig) && hibernateConnectionConfigured);

            String formsPersistConfig = DIFGeneralConfigurationParameters.getInstance().getCustomForms();
            boolean formsDatabasePersistance = "Y".equalsIgnoreCase(formsPersistConfig)
                    || ("D".equalsIgnoreCase(formsPersistConfig) && hibernateConnectionConfigured);

            this.enabled = (eCommerce.size() > 0) || (authorizationManager != null) || (messageManager != null)
                    || (identityManager != null) || poolsDatabasePersistance || formsDatabasePersistance;
        }

        if (this.enabled && !hibernateConnectionConfigured)
            throw new InternalFrameworkException(
                    "The dif-database-repository hibernate configurations are not correctly configured! Please configure the database access configuration (Ex: url, user, password) and run this process again.",
                    null);

        return this.enabled;
    }
}
