package pt.digitalis.dif.dem.managers.impl.model;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.dif.dem.managers.impl.model.dao.IUsersDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Users;
import pt.digitalis.dif.dem.managers.impl.model.dao.IUserAttributesDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.UserAttributes;
import pt.digitalis.dif.dem.managers.impl.model.dao.IGroupsDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Groups;
import pt.digitalis.dif.dem.managers.impl.model.dao.IUserGroupsDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.UserGroups;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public interface IIdentityService {

    /**
     * Obtains a new Users DAO
     *
     * @return A new IUsersDAO
     */
    public IUsersDAO getUsersDAO();

    /**
     * Obtains a new DataSet for the Users entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Users> getUsersDataSet();

    /**
     * Obtains a new UserAttributes DAO
     *
     * @return A new IUserAttributesDAO
     */
    public IUserAttributesDAO getUserAttributesDAO();

    /**
     * Obtains a new DataSet for the UserAttributes entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserAttributes> getUserAttributesDataSet();

    /**
     * Obtains a new Groups DAO
     *
     * @return A new IGroupsDAO
     */
    public IGroupsDAO getGroupsDAO();

    /**
     * Obtains a new DataSet for the Groups entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Groups> getGroupsDataSet();

    /**
     * Obtains a new UserGroups DAO
     *
     * @return A new IUserGroupsDAO
     */
    public IUserGroupsDAO getUserGroupsDAO();

    /**
     * Obtains a new DataSet for the UserGroups entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserGroups> getUserGroupsDataSet();

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz);

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName);
}