package pt.digitalis.dif.dem.managers.impl.model.dao.auto;

import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.Acl;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Acl. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Acl
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoAclDAO extends IHibernateDAO<Acl> {

    /**
     * Obtains a new DataSet for the Acl entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Acl> getAclDataSet();

    /**
     * Persist a Acl object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(Acl transientInstance);

    /**
     * Updates a modified Acl in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(Acl instance);

    /**
     * Attach an unmodified Acl instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(Acl instance);

    /**
     * Removes a Acl instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(Acl persistentInstance);

    /**
     * Merge a Acl instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public Acl merge(Acl detachedInstance);

    /**
     * Finds a Acl instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public Acl findById(java.lang.Long id);

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    public List<Acl> findAll();

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than partially match the given field with the
     * given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByFieldParcial(Acl.Fields field, String value);

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the userId attribute with the given
     * value
     *
     * @param userId
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByUserId(String userId);

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the groupId attribute with the given
     * value
     *
     * @param groupId
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByGroupId(String groupId);

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the entityType attribute with the
     * given value
     *
     * @param entityType
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByEntityType(String entityType);

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the entityId attribute with the
     * given value
     *
     * @param entityId
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByEntityId(String entityId);

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the publicAccess attribute with the
     * given value
     *
     * @param publicAccess
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByPublicAccess(String publicAccess);

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the isEnabled attribute with the
     * given value
     *
     * @param isEnabled
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByIsEnabled(String isEnabled);

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the isDefault attribute with the
     * given value
     *
     * @param isDefault
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByIsDefault(String isDefault);
}
