package pt.digitalis.dif.dem.managers.impl.model.dao.auto;

import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.Groups;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Groups. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Groups
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoGroupsDAO extends IHibernateDAO<Groups> {

    /**
     * Obtains a new DataSet for the Groups entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Groups> getGroupsDataSet();

    /**
     * Persist a Groups object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(Groups transientInstance);

    /**
     * Updates a modified Groups in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(Groups instance);

    /**
     * Attach an unmodified Groups instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(Groups instance);

    /**
     * Removes a Groups instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(Groups persistentInstance);

    /**
     * Merge a Groups instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public Groups merge(Groups detachedInstance);

    /**
     * Finds a Groups instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public Groups findById(java.lang.String id);

    /**
     * Gets a {@link List} of all Groups instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    public List<Groups> findAll();

    /**
     * Gets a {@link List} of all Groups instances in the persistence layer than partially match the given field with
     * the given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    public List<Groups> findByFieldParcial(Groups.Fields field, String value);

    /**
     * Gets a {@link List} of all Groups instances in the persistence layer than match the name attribute with the given
     * value
     *
     * @param name
     *            to match
     * @return the {@link List} of instances
     */
    public List<Groups> findByName(String name);

    /**
     * Gets a {@link List} of all Groups instances in the persistence layer than match the description attribute with
     * the given value
     *
     * @param description
     *            to match
     * @return the {@link List} of instances
     */
    public List<Groups> findByDescription(String description);

    /**
     * Gets a {@link List} of all Groups instances in the persistence layer than match the defaultGroup attribute with
     * the given value
     *
     * @param defaultGroup
     *            to match
     * @return the {@link List} of instances
     */
    public List<Groups> findByDefaultGroup(boolean defaultGroup);
}
