package pt.digitalis.dif.dem.managers.impl.model.dao.auto;

import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.Users;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Users. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Users
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoUsersDAO extends IHibernateDAO<Users> {

    /**
     * Obtains a new DataSet for the Users entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Users> getUsersDataSet();

    /**
     * Persist a Users object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(Users transientInstance);

    /**
     * Updates a modified Users in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(Users instance);

    /**
     * Attach an unmodified Users instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(Users instance);

    /**
     * Removes a Users instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(Users persistentInstance);

    /**
     * Merge a Users instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public Users merge(Users detachedInstance);

    /**
     * Finds a Users instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public Users findById(java.lang.String id);

    /**
     * Gets a {@link List} of all Users instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    public List<Users> findAll();

    /**
     * Gets a {@link List} of all Users instances in the persistence layer than partially match the given field with the
     * given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    public List<Users> findByFieldParcial(Users.Fields field, String value);

    /**
     * Gets a {@link List} of all Users instances in the persistence layer than match the email attribute with the given
     * value
     *
     * @param email
     *            to match
     * @return the {@link List} of instances
     */
    public List<Users> findByEmail(String email);

    /**
     * Gets a {@link List} of all Users instances in the persistence layer than match the enabled attribute with the
     * given value
     *
     * @param enabled
     *            to match
     * @return the {@link List} of instances
     */
    public List<Users> findByEnabled(boolean enabled);

    /**
     * Gets a {@link List} of all Users instances in the persistence layer than match the name attribute with the given
     * value
     *
     * @param name
     *            to match
     * @return the {@link List} of instances
     */
    public List<Users> findByName(String name);

    /**
     * Gets a {@link List} of all Users instances in the persistence layer than match the password attribute with the
     * given value
     *
     * @param password
     *            to match
     * @return the {@link List} of instances
     */
    public List<Users> findByPassword(String password);

    /**
     * Gets a {@link List} of all Users instances in the persistence layer than match the defaultUser attribute with the
     * given value
     *
     * @param defaultUser
     *            to match
     * @return the {@link List} of instances
     */
    public List<Users> findByDefaultUser(boolean defaultUser);

    /**
     * Gets a {@link List} of all Users instances in the persistence layer than match the nick attribute with the given
     * value
     *
     * @param nick
     *            to match
     * @return the {@link List} of instances
     */
    public List<Users> findByNick(String nick);
}
