package pt.digitalis.dif.dem.managers.impl.model.dao.impl;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import pt.digitalis.dif.dem.managers.impl.model.dao.IPersistentActionDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.AutoPersistentActionDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.PersistentAction;

/**
 * Home object for domain model class PersistentAction. Generated on Nov 25, 2009 DIF build process for the Model layer
 * 
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class PersistentActionDAOImpl extends AutoPersistentActionDAOImpl implements IPersistentActionDAO {

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.IPersistentActionDAO#deleteActionByInternalIdAndName(java.lang.Long,
     *      java.lang.String)
     */
    public void deleteActionByInternalIdAndName(Long actionId, String poolName)
    {
        Query query = this.getSession()
                .createQuery("DELETE FROM PersistentAction WHERE " + PersistentAction.Fields.ACTIONID.toString() + "= :"
                        + PersistentAction.Fields.ACTIONID.toString() + " AND "
                        + PersistentAction.Fields.POOLNAME.toString() + " = :"
                        + PersistentAction.Fields.POOLNAME.toString());

        query.setLong(PersistentAction.Fields.ACTIONID.toString(), actionId);
        query.setString(PersistentAction.Fields.POOLNAME.toString(), poolName);
        query.executeUpdate();
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.IPersistentActionDAO#getAction(java.lang.Long,
     *      java.lang.String)
     */
    public PersistentAction getAction(Long actionId, String poolName)
    {
        Criteria criteria = this.getSession().createCriteria(PersistentAction.class);
        criteria.add(Restrictions.eq(PersistentAction.Fields.POOLNAME.toString(), poolName));
        criteria.add(Restrictions.eq(PersistentAction.Fields.ACTIONID.toString(), actionId));
        return (PersistentAction) criteria.uniqueResult();
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.IPersistentActionDAO#getActionsByPool(java.lang.String)
     */
    @SuppressWarnings("unchecked")
    public List<PersistentAction> getActionsByPool(String poolName)
    {
        Criteria criteria = this.getSession().createCriteria(PersistentAction.class);
        criteria.add(Restrictions.eq(PersistentAction.Fields.POOLNAME.toString(), poolName));
        criteria.addOrder(Order.asc(PersistentAction.Fields.ACTIONID.toString()));
        return criteria.list();
    }
}