package pt.digitalis.dif.dem.managers.impl.model.data;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pt.digitalis.dif.model.utils.AbstractBeanAttributes;

/**
 * AuditLog Generated on ORM Generator DIF build process for the Model layer
 */
@SuppressWarnings("serial")
public class AuditLog extends AbstractBeanAttributes implements java.io.Serializable {

    /** AuditLog attributes enumeration */
    public static class Fields {

        /** id column */
        public static final String ID = "id";
        /** app column */
        public static final String APP = "app";
        /** userid column */
        public static final String USERID = "userid";
        /** entityName column */
        public static final String ENTITYNAME = "entityName";
        /** operation column */
        public static final String OPERATION = "operation";
        /** operationDate column */
        public static final String OPERATIONDATE = "operationDate";
        /** instanceId column */
        public static final String INSTANCEID = "instanceId";
        /** process column */
        public static final String PROCESS = "process";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("app");
            list.add("userid");
            list.add("entityName");
            list.add("operation");
            list.add("operationDate");
            list.add("instanceId");
            list.add("process");

            return list;
        }
    }

    /** AuditLog FK class */
    public static class FK {

        /** auditLogDetails relation */
        public static final String AUDITLOGDETAILS = "auditLogDetails";
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    protected Object getAttributeNoGraphNavigation(String attributeName)
    {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("app".equalsIgnoreCase(attributeName))
            return app;
        if ("userid".equalsIgnoreCase(attributeName))
            return userid;
        if ("entityName".equalsIgnoreCase(attributeName))
            return entityName;
        if ("operation".equalsIgnoreCase(attributeName))
            return operation;
        if ("operationDate".equalsIgnoreCase(attributeName))
            return operationDate;
        if ("instanceId".equalsIgnoreCase(attributeName))
            return instanceId;
        if ("process".equalsIgnoreCase(attributeName))
            return process;
        if ("auditLogDetails".equalsIgnoreCase(attributeName))
            return auditLogDetails;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue)
    {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long) attributeValue;
        if ("app".equalsIgnoreCase(attributeName))
            app = (String) attributeValue;
        if ("userid".equalsIgnoreCase(attributeName))
            userid = (String) attributeValue;
        if ("entityName".equalsIgnoreCase(attributeName))
            entityName = (String) attributeValue;
        if ("operation".equalsIgnoreCase(attributeName))
            operation = (Character) attributeValue;
        if ("operationDate".equalsIgnoreCase(attributeName))
            operationDate = (Timestamp) attributeValue;
        if ("instanceId".equalsIgnoreCase(attributeName))
            instanceId = (String) attributeValue;
        if ("process".equalsIgnoreCase(attributeName))
            process = (String) attributeValue;
        if ("auditLogDetails".equalsIgnoreCase(attributeName))
            auditLogDetails = (Set<AuditLogDetail>) attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** app private attribute */
    private String app;

    /** userid private attribute */
    private String userid;

    /** entityName private attribute */
    private String entityName;

    /** operation private attribute */
    private Character operation;

    /** operationDate private attribute */
    private Timestamp operationDate;

    /** instanceId private attribute */
    private String instanceId;

    /** process private attribute */
    private String process;

    /** auditLogDetails private attribute */
    private Set<AuditLogDetail> auditLogDetails = new HashSet<AuditLogDetail>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    public synchronized static List<String> getPKFieldList()
    {
        if (pkFieldList == null)
        {
            pkFieldList = new ArrayList<String>();
            pkFieldList.add("id");
        }

        return pkFieldList;
    }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
    public static String getPKFieldListAsString()
    {
        StringBuffer buffer = new StringBuffer();

        for (int i = 0; i < getPKFieldList().size(); i++)
        {
            if (i != 0)
                buffer.append(",");

            buffer.append(getPKFieldList().get(i));
        }

        return buffer.toString();
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
    @Override
    public String getAttributeAsString(String attributeName)
    {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else
        {
            return value.toString().trim();
        }
    }

    // Constructors

    /**
     * default constructor
     */
    public AuditLog()
    {}

    /**
     * minimal constructor
     *
     * @param userid
     * @param entityName
     * @param operation
     * @param operationDate
     * @param process
     *            }
     */
    public AuditLog(String userid, String entityName, Character operation, Timestamp operationDate, String process)
    {
        this.userid = userid;
        this.entityName = entityName;
        this.operation = operation;
        this.operationDate = operationDate;
        this.process = process;
    }

    /**
     * full constructor
     *
     * @param app
     * @param userid
     * @param entityName
     * @param operation
     * @param operationDate
     * @param instanceId
     * @param process
     * @param auditLogDetails
     */
    public AuditLog(String app, String userid, String entityName, Character operation, Timestamp operationDate,
            String instanceId, String process, Set<AuditLogDetail> auditLogDetails)
    {
        this.app = app;
        this.userid = userid;
        this.entityName = entityName;
        this.operation = operation;
        this.operationDate = operationDate;
        this.instanceId = instanceId;
        this.process = process;
        this.auditLogDetails = auditLogDetails;
    }

    // Property accessors

    /**
     * id getter method
     *
     * @return id method
     */
    public Long getId()
    {
        return this.id;
    }

    /**
     * id setter method
     *
     * @param id
     * @return AuditLog modified instance
     */
    public AuditLog setId(Long id)
    {
        this.id = id;

        return this;
    }

    /**
     * app getter method
     *
     * @return app method
     */
    public String getApp()
    {
        return this.app;
    }

    /**
     * app setter method
     *
     * @param app
     * @return AuditLog modified instance
     */
    public AuditLog setApp(String app)
    {
        this.app = app;

        return this;
    }

    /**
     * userid getter method
     *
     * @return userid method
     */
    public String getUserid()
    {
        return this.userid;
    }

    /**
     * userid setter method
     *
     * @param userid
     * @return AuditLog modified instance
     */
    public AuditLog setUserid(String userid)
    {
        this.userid = userid;

        return this;
    }

    /**
     * entityName getter method
     *
     * @return entityName method
     */
    public String getEntityName()
    {
        return this.entityName;
    }

    /**
     * entityName setter method
     *
     * @param entityName
     * @return AuditLog modified instance
     */
    public AuditLog setEntityName(String entityName)
    {
        this.entityName = entityName;

        return this;
    }

    /**
     * operation getter method
     *
     * @return operation method
     */
    public Character getOperation()
    {
        return this.operation;
    }

    /**
     * operation setter method
     *
     * @param operation
     * @return AuditLog modified instance
     */
    public AuditLog setOperation(Character operation)
    {
        this.operation = operation;

        return this;
    }

    /**
     * operationDate getter method
     *
     * @return operationDate method
     */
    public Timestamp getOperationDate()
    {
        return this.operationDate;
    }

    /**
     * operationDate setter method
     *
     * @param operationDate
     * @return AuditLog modified instance
     */
    public AuditLog setOperationDate(Timestamp operationDate)
    {
        this.operationDate = operationDate;

        return this;
    }

    /**
     * instanceId getter method
     *
     * @return instanceId method
     */
    public String getInstanceId()
    {
        return this.instanceId;
    }

    /**
     * instanceId setter method
     *
     * @param instanceId
     * @return AuditLog modified instance
     */
    public AuditLog setInstanceId(String instanceId)
    {
        this.instanceId = instanceId;

        return this;
    }

    /**
     * process getter method
     *
     * @return process method
     */
    public String getProcess()
    {
        return this.process;
    }

    /**
     * process setter method
     *
     * @param process
     * @return AuditLog modified instance
     */
    public AuditLog setProcess(String process)
    {
        this.process = process;

        return this;
    }

    /**
     * auditLogDetails getter method
     *
     * @return auditLogDetails method
     */
    public Set<AuditLogDetail> getAuditLogDetails()
    {
        return this.auditLogDetails;
    }

    /**
     * auditLogDetails setter method
     *
     * @param auditLogDetails
     * @return AuditLog modified instance
     */
    public AuditLog setAuditLogDetails(Set<AuditLogDetail> auditLogDetails)
    {
        this.auditLogDetails = auditLogDetails;

        return this;
    }

    /**
     * Creates a String representation of the AuditLog object
     *
     * @return the compiled String
     */
    public String toString()
    {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");
        buffer.append("app").append("='").append(getApp()).append("' ");
        buffer.append("userid").append("='").append(getUserid()).append("' ");
        buffer.append("entityName").append("='").append(getEntityName()).append("' ");
        buffer.append("operation").append("='").append(getOperation()).append("' ");
        buffer.append("operationDate").append("='").append(getOperationDate()).append("' ");
        buffer.append("instanceId").append("='").append(getInstanceId()).append("' ");
        buffer.append("process").append("='").append(getProcess()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    /**
     * Compares the String representation of the AuditLog object
     *
     * @param other
     *            The object to compare to
     * @return true of the objects are equal
     */
    public boolean equals(AuditLog other)
    {
        return this.toString().equals(other.toString());
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue)
    {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("app".equalsIgnoreCase(attributeName))
            this.app = attributeValue;

        if ("userid".equalsIgnoreCase(attributeName))
            this.userid = attributeValue;

        if ("entityName".equalsIgnoreCase(attributeName))
            this.entityName = attributeValue;

        if ("operation".equalsIgnoreCase(attributeName))
            if (attributeValue != null && attributeValue.length() > 0)
                this.operation = attributeValue.charAt(0);

        if ("operationDate".equalsIgnoreCase(attributeName))
            this.operationDate = Timestamp.valueOf(attributeValue);

        if ("instanceId".equalsIgnoreCase(attributeName))
            this.instanceId = attributeValue;

        if ("process".equalsIgnoreCase(attributeName))
            this.process = attributeValue;

    }

}
