package pt.digitalis.dif.dem.managers.impl.model.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pt.digitalis.dif.model.utils.AbstractBeanAttributes;

/**
 * Groups Generated on ORM Generator DIF build process for the Model layer
 */
@SuppressWarnings("serial")
public class Groups extends AbstractBeanAttributes implements java.io.Serializable {

    /** Groups attributes enumeration */
    public static class Fields {

        /** id column */
        public static final String ID = "id";
        /** name column */
        public static final String NAME = "name";
        /** description column */
        public static final String DESCRIPTION = "description";
        /** defaultGroup column */
        public static final String DEFAULTGROUP = "defaultGroup";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("description");
            list.add("defaultGroup");

            return list;
        }
    }

    /** Groups FK class */
    public static class FK {

        /** groups relation */
        public static final String GROUPS = "groups";
        /** userses relation */
        public static final String USERSES = "userses";
        /** userGroupses relation */
        public static final String USERGROUPSES = "userGroupses";
        /** groupses relation */
        public static final String GROUPSES = "groupses";
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    protected Object getAttributeNoGraphNavigation(String attributeName)
    {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("groups".equalsIgnoreCase(attributeName))
            return groups;
        if ("name".equalsIgnoreCase(attributeName))
            return name;
        if ("description".equalsIgnoreCase(attributeName))
            return description;
        if ("defaultGroup".equalsIgnoreCase(attributeName))
            return defaultGroup;
        if ("userses".equalsIgnoreCase(attributeName))
            return userses;
        if ("userGroupses".equalsIgnoreCase(attributeName))
            return userGroupses;
        if ("groupses".equalsIgnoreCase(attributeName))
            return groupses;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue)
    {

        if ("id".equalsIgnoreCase(attributeName))
            id = (String) attributeValue;
        if ("groups".equalsIgnoreCase(attributeName))
            groups = (Groups) attributeValue;
        if ("name".equalsIgnoreCase(attributeName))
            name = (String) attributeValue;
        if ("description".equalsIgnoreCase(attributeName))
            description = (String) attributeValue;
        if ("defaultGroup".equalsIgnoreCase(attributeName))
            defaultGroup = (Boolean) attributeValue;
        if ("userses".equalsIgnoreCase(attributeName))
            userses = (Set<Users>) attributeValue;
        if ("userGroupses".equalsIgnoreCase(attributeName))
            userGroupses = (Set<UserGroups>) attributeValue;
        if ("groupses".equalsIgnoreCase(attributeName))
            groupses = (Set<Groups>) attributeValue;
    }

    // Fields

    /** id private attribute */
    private String id;

    /** groups private attribute */
    private Groups groups;

    /** name private attribute */
    private String name;

    /** description private attribute */
    private String description;

    /** defaultGroup private attribute */
    private boolean defaultGroup;

    /** userses private attribute */
    private Set<Users> userses = new HashSet<Users>(0);

    /** userGroupses private attribute */
    private Set<UserGroups> userGroupses = new HashSet<UserGroups>(0);

    /** groupses private attribute */
    private Set<Groups> groupses = new HashSet<Groups>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    public synchronized static List<String> getPKFieldList()
    {
        if (pkFieldList == null)
        {
            pkFieldList = new ArrayList<String>();
            pkFieldList.add("id");
        }

        return pkFieldList;
    }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
    public static String getPKFieldListAsString()
    {
        StringBuffer buffer = new StringBuffer();

        for (int i = 0; i < getPKFieldList().size(); i++)
        {
            if (i != 0)
                buffer.append(",");

            buffer.append(getPKFieldList().get(i));
        }

        return buffer.toString();
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
    @Override
    public String getAttributeAsString(String attributeName)
    {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else
        {
            return value.toString().trim();
        }
    }

    // Constructors

    /**
     * default constructor
     */
    public Groups()
    {}

    /**
     * minimal constructor
     *
     * @param id
     * @param name
     * @param defaultGroup
     *            }
     */
    public Groups(String id, String name, boolean defaultGroup)
    {
        this.id = id;
        this.name = name;
        this.defaultGroup = defaultGroup;
    }

    /**
     * full constructor
     *
     * @param id
     * @param groups
     * @param name
     * @param description
     * @param defaultGroup
     * @param userses
     * @param userGroupses
     * @param groupses
     */
    public Groups(String id, Groups groups, String name, String description, boolean defaultGroup, Set<Users> userses,
            Set<UserGroups> userGroupses, Set<Groups> groupses)
    {
        this.id = id;
        this.groups = groups;
        this.name = name;
        this.description = description;
        this.defaultGroup = defaultGroup;
        this.userses = userses;
        this.userGroupses = userGroupses;
        this.groupses = groupses;
    }

    // Property accessors

    /**
     * id getter method
     *
     * @return id method
     */
    public String getId()
    {
        return this.id;
    }

    /**
     * id setter method
     *
     * @param id
     * @return Groups modified instance
     */
    public Groups setId(String id)
    {
        this.id = id;

        return this;
    }

    /**
     * groups getter method
     *
     * @return groups method
     */
    public Groups getGroups()
    {
        return this.groups;
    }

    /**
     * groups setter method
     *
     * @param groups
     * @return Groups modified instance
     */
    public Groups setGroups(Groups groups)
    {
        this.groups = groups;

        return this;
    }

    /**
     * name getter method
     *
     * @return name method
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * name setter method
     *
     * @param name
     * @return Groups modified instance
     */
    public Groups setName(String name)
    {
        this.name = name;

        return this;
    }

    /**
     * description getter method
     *
     * @return description method
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * description setter method
     *
     * @param description
     * @return Groups modified instance
     */
    public Groups setDescription(String description)
    {
        this.description = description;

        return this;
    }

    /**
     * defaultGroup getter method
     *
     * @return defaultGroup method
     */
    public boolean isDefaultGroup()
    {
        return this.defaultGroup;
    }

    /**
     * defaultGroup setter method
     *
     * @param defaultGroup
     * @return Groups modified instance
     */
    public Groups setDefaultGroup(boolean defaultGroup)
    {
        this.defaultGroup = defaultGroup;

        return this;
    }

    /**
     * userses getter method
     *
     * @return userses method
     */
    public Set<Users> getUserses()
    {
        return this.userses;
    }

    /**
     * userses setter method
     *
     * @param userses
     * @return Groups modified instance
     */
    public Groups setUserses(Set<Users> userses)
    {
        this.userses = userses;

        return this;
    }

    /**
     * userGroupses getter method
     *
     * @return userGroupses method
     */
    public Set<UserGroups> getUserGroupses()
    {
        return this.userGroupses;
    }

    /**
     * userGroupses setter method
     *
     * @param userGroupses
     * @return Groups modified instance
     */
    public Groups setUserGroupses(Set<UserGroups> userGroupses)
    {
        this.userGroupses = userGroupses;

        return this;
    }

    /**
     * groupses getter method
     *
     * @return groupses method
     */
    public Set<Groups> getGroupses()
    {
        return this.groupses;
    }

    /**
     * groupses setter method
     *
     * @param groupses
     * @return Groups modified instance
     */
    public Groups setGroupses(Set<Groups> groupses)
    {
        this.groupses = groupses;

        return this;
    }

    /**
     * Creates a String representation of the Groups object
     *
     * @return the compiled String
     */
    public String toString()
    {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");
        buffer.append("name").append("='").append(getName()).append("' ");
        buffer.append("description").append("='").append(getDescription()).append("' ");
        buffer.append("defaultGroup").append("='").append(isDefaultGroup()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    /**
     * Compares the String representation of the Groups object
     *
     * @param other
     *            The object to compare to
     * @return true of the objects are equal
     */
    public boolean equals(Groups other)
    {
        return this.toString().equals(other.toString());
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue)
    {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = attributeValue;

        if ("name".equalsIgnoreCase(attributeName))
            this.name = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
            this.description = attributeValue;

        if ("defaultGroup".equalsIgnoreCase(attributeName))
            this.defaultGroup = Boolean.valueOf(attributeValue);

    }

}
