package pt.digitalis.dif.dem.managers.impl.model.data;

import java.util.ArrayList;
import java.util.List;
import pt.digitalis.dif.model.utils.AbstractBeanAttributes;

/**
 * UserAttributes Generated on ORM Generator DIF build process for the Model layer
 */
@SuppressWarnings("serial")
public class UserAttributes extends AbstractBeanAttributes implements java.io.Serializable {

    /** UserAttributes attributes enumeration */
    public static class Fields {

        /** id column */
        public static final String ID = "id";
        /** attributeKey column */
        public static final String ATTRIBUTEKEY = "attributeKey";
        /** attributeValue column */
        public static final String ATTRIBUTEVALUE = "attributeValue";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("attributeKey");
            list.add("attributeValue");

            return list;
        }
    }

    /** UserAttributes FK class */
    public static class FK {

        /** users relation */
        public static final String USERS = "users";
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    protected Object getAttributeNoGraphNavigation(String attributeName)
    {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("users".equalsIgnoreCase(attributeName))
            return users;
        if ("attributeKey".equalsIgnoreCase(attributeName))
            return attributeKey;
        if ("attributeValue".equalsIgnoreCase(attributeName))
            return attributeValue;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue)
    {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long) attributeValue;
        if ("users".equalsIgnoreCase(attributeName))
            users = (Users) attributeValue;
        if ("attributeKey".equalsIgnoreCase(attributeName))
            attributeKey = (String) attributeValue;
        if ("attributeValue".equalsIgnoreCase(attributeName))
            attributeValue = (String) attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** users private attribute */
    private Users users;

    /** attributeKey private attribute */
    private String attributeKey;

    /** attributeValue private attribute */
    private String attributeValue;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    public synchronized static List<String> getPKFieldList()
    {
        if (pkFieldList == null)
        {
            pkFieldList = new ArrayList<String>();
            pkFieldList.add("id");
        }

        return pkFieldList;
    }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
    public static String getPKFieldListAsString()
    {
        StringBuffer buffer = new StringBuffer();

        for (int i = 0; i < getPKFieldList().size(); i++)
        {
            if (i != 0)
                buffer.append(",");

            buffer.append(getPKFieldList().get(i));
        }

        return buffer.toString();
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
    @Override
    public String getAttributeAsString(String attributeName)
    {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else
        {
            return value.toString().trim();
        }
    }

    // Constructors

    /**
     * default constructor
     */
    public UserAttributes()
    {}

    /**
     * minimal constructor
     *
     * @param users
     * @param attributeKey
     *            }
     */
    public UserAttributes(Users users, String attributeKey)
    {
        this.users = users;
        this.attributeKey = attributeKey;
    }

    /**
     * full constructor
     *
     * @param users
     * @param attributeKey
     * @param attributeValue
     */
    public UserAttributes(Users users, String attributeKey, String attributeValue)
    {
        this.users = users;
        this.attributeKey = attributeKey;
        this.attributeValue = attributeValue;
    }

    // Property accessors

    /**
     * id getter method
     *
     * @return id method
     */
    public Long getId()
    {
        return this.id;
    }

    /**
     * id setter method
     *
     * @param id
     * @return UserAttributes modified instance
     */
    public UserAttributes setId(Long id)
    {
        this.id = id;

        return this;
    }

    /**
     * users getter method
     *
     * @return users method
     */
    public Users getUsers()
    {
        return this.users;
    }

    /**
     * users setter method
     *
     * @param users
     * @return UserAttributes modified instance
     */
    public UserAttributes setUsers(Users users)
    {
        this.users = users;

        return this;
    }

    /**
     * attributeKey getter method
     *
     * @return attributeKey method
     */
    public String getAttributeKey()
    {
        return this.attributeKey;
    }

    /**
     * attributeKey setter method
     *
     * @param attributeKey
     * @return UserAttributes modified instance
     */
    public UserAttributes setAttributeKey(String attributeKey)
    {
        this.attributeKey = attributeKey;

        return this;
    }

    /**
     * attributeValue getter method
     *
     * @return attributeValue method
     */
    public String getAttributeValue()
    {
        return this.attributeValue;
    }

    /**
     * attributeValue setter method
     *
     * @param attributeValue
     * @return UserAttributes modified instance
     */
    public UserAttributes setAttributeValue(String attributeValue)
    {
        this.attributeValue = attributeValue;

        return this;
    }

    /**
     * Creates a String representation of the UserAttributes object
     *
     * @return the compiled String
     */
    public String toString()
    {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");
        buffer.append("attributeKey").append("='").append(getAttributeKey()).append("' ");
        buffer.append("attributeValue").append("='").append(getAttributeValue()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    /**
     * Compares the String representation of the UserAttributes object
     *
     * @param other
     *            The object to compare to
     * @return true of the objects are equal
     */
    public boolean equals(UserAttributes other)
    {
        return this.toString().equals(other.toString());
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue)
    {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("attributeKey".equalsIgnoreCase(attributeName))
            this.attributeKey = attributeValue;

        if ("attributeValue".equalsIgnoreCase(attributeName))
            this.attributeValue = attributeValue;

    }

}
