/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoAuditLogDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.AuditLog;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoAuditLogDAOImpl
implements IAutoAuditLogDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<AuditLog> getAuditLogDataSet() {
        return new HibernateDataSet(AuditLog.class, (IHibernateDAO)this, AuditLog.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(AuditLog transientInstance) {
        this.logger.debug((Object)"persisting AuditLog instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(AuditLog instance) {
        this.logger.debug((Object)"attaching dirty AuditLog instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(AuditLog instance) {
        this.logger.debug((Object)"attaching clean AuditLog instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(AuditLog persistentInstance) {
        this.logger.debug((Object)"deleting AuditLog instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public AuditLog merge(AuditLog detachedInstance) {
        this.logger.debug((Object)"merging AuditLog instance");
        AuditLog result = (AuditLog)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public AuditLog findById(Long id) {
        this.logger.debug((Object)("getting AuditLog instance with id: " + id));
        AuditLog instance = (AuditLog)this.getSession().get(AuditLog.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<AuditLog> findAll() {
        List<AuditLog> instances = new ArrayList();
        this.logger.debug((Object)"getting all AuditLog instances");
        instances = this.getSession().createCriteria(AuditLog.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<AuditLog> findByExample(AuditLog instance) {
        this.logger.debug((Object)"finding AuditLog instance by example");
        List results = this.getSession().createCriteria(AuditLog.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<AuditLog> findByFieldParcial(AuditLog.Fields field, String value) {
        this.logger.debug((Object)("finding AuditLog instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(AuditLog.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<AuditLog> findByApp(String app) {
        AuditLog instance = new AuditLog();
        instance.setApp(app);
        return this.findByExample(instance);
    }

    @Override
    public List<AuditLog> findByUserid(String userid) {
        AuditLog instance = new AuditLog();
        instance.setUserid(userid);
        return this.findByExample(instance);
    }

    @Override
    public List<AuditLog> findByEntityName(String entityName) {
        AuditLog instance = new AuditLog();
        instance.setEntityName(entityName);
        return this.findByExample(instance);
    }

    @Override
    public List<AuditLog> findByOperation(Character operation) {
        AuditLog instance = new AuditLog();
        instance.setOperation(operation);
        return this.findByExample(instance);
    }

    @Override
    public List<AuditLog> findByOperationDate(Timestamp operationDate) {
        AuditLog instance = new AuditLog();
        instance.setOperationDate(operationDate);
        return this.findByExample(instance);
    }

    @Override
    public List<AuditLog> findByInstanceId(String instanceId) {
        AuditLog instance = new AuditLog();
        instance.setInstanceId(instanceId);
        return this.findByExample(instance);
    }

    @Override
    public List<AuditLog> findByProcess(String process) {
        AuditLog instance = new AuditLog();
        instance.setProcess(process);
        return this.findByExample(instance);
    }
}

