DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.ACL 
(
  ID            INT(10) NOT NULL AUTO_INCREMENT,
  USER_ID       VARCHAR(255),
  GROUP_ID      VARCHAR(255),
  ENTITY_TYPE   VARCHAR(255),
  ENTITY_ID     VARCHAR(255),
  PUBLIC_ACCESS VARCHAR(1),
  IS_ENABLED    VARCHAR(1),
  IS_DEFAULT    VARCHAR(1),
  PRIMARY KEY (`ID`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.CUSTOM_MESSAGES
(
  ID         INT DEFAULT 0 NOT NULL COMMENT 'PK', 
  MESSAGE_ID VARCHAR(4000) NOT NULL COMMENT 'O IDENTIFICADOR DA MENSAGEM NA PAGINA.',
  MESSAGE    VARCHAR(4000) NOT NULL COMMENT 'O VALOR DA MENSAGEM.',
  ENTITY_ID  VARCHAR(4000) NOT NULL COMMENT 'ID DA ENTIDADE A QUAL PERTENCE A MENSAGEM. TEM A FORMA: TIPO_DA_ENTIDADE:NOME_DA_ENTIDADE. EX.: STAGE:HOMESTAGE.',
  LANGUAGE   VARCHAR(4000) COMMENT 'LINGUA',
  PRIMARY KEY (`ID`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.`GROUPS` (
  `ID` VARCHAR(200) COLLATE UTF8_BIN NOT NULL,
  `NAME` VARCHAR(200) COLLATE UTF8_BIN NOT NULL,
  `DESCRIPTION` VARCHAR(500) COLLATE UTF8_BIN DEFAULT NULL,
  `PARENT_GROUPID` VARCHAR(200) COLLATE UTF8_BIN DEFAULT NULL,
  `DEFAULT_GROUP` TINYINT(1) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `FK_GROUPS_GROUPS_IDX` (`PARENT_GROUPID`),
  CONSTRAINT `FK_GROUPS_GROUPS` FOREIGN KEY (`PARENT_GROUPID`) REFERENCES `GROUPS` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

DELIMITER $$
CREATE TABLE IF NOT EXISTS `USERS` (
  `ID` VARCHAR(200) COLLATE UTF8_BIN NOT NULL,
  `PROFILEID` VARCHAR(200) COLLATE UTF8_BIN DEFAULT NULL,
  `EMAIL` VARCHAR(45) COLLATE UTF8_BIN DEFAULT NULL,
  `ENABLED` TINYINT(1) NOT NULL,
  `NAME` VARCHAR(500) COLLATE UTF8_BIN DEFAULT NULL,
  `PASSWORD` VARCHAR(200) COLLATE UTF8_BIN NOT NULL,
  `DEFAULT_USER` TINYINT(1) NOT NULL,
  `NICK` VARCHAR(45) COLLATE UTF8_BIN DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `FK_USERS_GROUPS_IDX` (`PROFILEID`),
  CONSTRAINT `FK_USERS_GROUPS` FOREIGN KEY (`PROFILEID`) REFERENCES `GROUPS` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

DELIMITER $$
CREATE TABLE IF NOT EXISTS `USER_ATTRIBUTES` (
  `ID` MEDIUMINT(9) NOT NULL AUTO_INCREMENT,
  `USERID` VARCHAR(200) COLLATE UTF8_BIN NOT NULL,
  `ATTRIBUTE_KEY` VARCHAR(200) COLLATE UTF8_BIN NOT NULL,
  `ATTRIBUTE_VALUE` VARCHAR(2000) COLLATE UTF8_BIN DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `USERID_UNIQUE` (`USERID`,`ATTRIBUTE_KEY`),
  KEY `FK_USER_ATTRIBUTES_IDX` (`USERID`),
  CONSTRAINT `FK_USER_ATTRIBUTES` FOREIGN KEY (`USERID`) REFERENCES `USERS` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=INNODB AUTO_INCREMENT=488 DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

DELIMITER $$
CREATE TABLE IF NOT EXISTS `USER_GROUPS` (
  `ID` MEDIUMINT(9) NOT NULL AUTO_INCREMENT,
  `USERID` VARCHAR(200) COLLATE UTF8_BIN DEFAULT NULL,
  `GROUPID` VARCHAR(200) COLLATE UTF8_BIN DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `INDEX2` (`USERID`,`GROUPID`),
  KEY `FK_USER_GROUPS_1_IDX` (`GROUPID`),
  KEY `FK_USER_GROUPS_2_IDX` (`USERID`),
  CONSTRAINT `FK_USER_GROUPS_1` FOREIGN KEY (`GROUPID`) REFERENCES `GROUPS` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `FK_USER_GROUPS_2` FOREIGN KEY (`USERID`) REFERENCES `USERS` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=INNODB AUTO_INCREMENT=394 DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.T_ECOMMERCE_PAYMENTS
(
  ID                  INT NOT NULL AUTO_INCREMENT,
  BUSINESS_ID         VARCHAR(50) NOT NULL,
  CREATOR             VARCHAR(50) NOT NULL,
  BUSINESS_CONTEXT    VARCHAR(4000),
  ECOMMERCE_PROCESSOR VARCHAR(50) NOT NULL,
  PAYMENT_VALUE       INT,
  STATUS              ENUM('W','R','P','F') NOT NULL,
  STATUS_MESSAGE      VARCHAR(4000),
  SECURITY_TOKEN      VARCHAR(1000),
  DATE_CREATION       DATE NOT NULL,
  DATE_RECEIVED       DATE,
  DATE_PROCESSED      DATE,
  TRANSACTION_DATE    DATE,
  REGISTER_ID         INT,
  TRANSACTION_ID      VARCHAR(100),
  AUTHORIZATION_ID    VARCHAR(20),
  REDIRECT_URL        VARCHAR(4000),
  CONFIGURATION_ID    VARCHAR(100) COMMENT 'IDENTIFICADOR DA CONFIGURAO UTILIZADA PARA INICIALIZAR O PAGAMENTO',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ECOMPAYMENTS_BUSINESS_ID_UK` (`BUSINESS_ID`),
  KEY `ECOMPAYMENTS_BUSINESS_IDX` (`BUSINESS_ID`),
  KEY `ECOMPAYMENTS_STATUS_IDX` (`STATUS`,`DATE_CREATION`),
  KEY `ECOMPAYMENTS_TOKEN_IDX` (`SECURITY_TOKEN`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

DELIMITER $$
CREATE TABLE IF NOT EXISTS `PERSISTENT_ACTION` (
  `ID` MEDIUMINT(9) NOT NULL AUTO_INCREMENT COMMENT 'O IDENTIFICADOR UNICO DA ACTION NA BD',
  `OBJECT_ACTION` BLOB NOT NULL COMMENT 'O OBJECTO ACTION SERIALIZED',
  `POOL_NAME` VARCHAR(250) DEFAULT NULL COMMENT 'O NOME UNICO DA POOL QUE CRIOU A ACTION',
  `ACTION_ID` MEDIUMINT(9) DEFAULT NULL COMMENT 'ACTION INTERNAL ID',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ACTION_ID_POOL_NAME` (`POOL_NAME`,`ACTION_ID`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8$$