package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.TemplateRepository;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class TemplateRepository.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.TemplateRepository
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoTemplateRepositoryDAO extends IHibernateDAO<TemplateRepository> {

    /**
     * Obtains a new DataSet for the TemplateRepository entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<TemplateRepository> getTemplateRepositoryDataSet();

	/**
	 * Persist a TemplateRepository object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(TemplateRepository transientInstance);

	/**
	 * Updates a modified TemplateRepository in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(TemplateRepository instance);

	/**
	 * Attach an unmodified TemplateRepository instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(TemplateRepository instance);

	/**
	 * Removes a TemplateRepository instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(TemplateRepository persistentInstance);

	/**
	 * Merge a TemplateRepository instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public TemplateRepository merge(TemplateRepository detachedInstance);

	/**
	 * Finds a TemplateRepository instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public TemplateRepository findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all TemplateRepository instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<TemplateRepository> findAll();


	/**
	 * Gets a {@link List} of all TemplateRepository instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<TemplateRepository> findByFieldParcial(TemplateRepository.Fields field, String value);

	/**
	 * Gets a {@link List} of all TemplateRepository instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<TemplateRepository> findByName(String name);

	/**
	 * Gets a {@link List} of all TemplateRepository instances
	 * in the persistence layer than match the language attribute with the given value
	 *
	 * @param language to match
	 * @return the {@link List} of instances
	 */
    public List<TemplateRepository> findByLanguage(String language);

	/**
	 * Gets a {@link List} of all TemplateRepository instances
	 * in the persistence layer than match the content attribute with the given value
	 *
	 * @param content to match
	 * @return the {@link List} of instances
	 */
    public List<TemplateRepository> findByContent(String content);
}
