package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplateAreaTrans;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoReportTemplateAreaTransDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ReportTemplateAreaTrans.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplateAreaTrans
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoReportTemplateAreaTransDAOImpl implements IAutoReportTemplateAreaTransDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ReportTemplateAreaTrans entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportTemplateAreaTrans> getReportTemplateAreaTransDataSet()
    {
        return new HibernateDataSet<ReportTemplateAreaTrans>(ReportTemplateAreaTrans.class, this, ReportTemplateAreaTrans.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoReportTemplateAreaTransDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ReportTemplateAreaTrans object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportTemplateAreaTrans transientInstance) {
        logger.debug("persisting ReportTemplateAreaTrans instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ReportTemplateAreaTrans in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportTemplateAreaTrans instance) {
        logger.debug("attaching dirty ReportTemplateAreaTrans instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ReportTemplateAreaTrans instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportTemplateAreaTrans instance) {
        logger.debug("attaching clean ReportTemplateAreaTrans instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ReportTemplateAreaTrans instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportTemplateAreaTrans persistentInstance) {
        logger.debug("deleting ReportTemplateAreaTrans instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ReportTemplateAreaTrans instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportTemplateAreaTrans merge(ReportTemplateAreaTrans detachedInstance) {
        logger.debug("merging ReportTemplateAreaTrans instance");
        ReportTemplateAreaTrans result = (ReportTemplateAreaTrans) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ReportTemplateAreaTrans instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportTemplateAreaTrans findById( java.lang.Long id) {
        logger.debug("getting ReportTemplateAreaTrans instance with id: " + id);
        ReportTemplateAreaTrans instance = (ReportTemplateAreaTrans) getSession()
                .get(ReportTemplateAreaTrans.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ReportTemplateAreaTrans instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportTemplateAreaTrans> findAll() {

 		List<ReportTemplateAreaTrans> instances = new ArrayList<ReportTemplateAreaTrans>();
		logger.debug("getting all ReportTemplateAreaTrans instances");
        instances = getSession().createCriteria(ReportTemplateAreaTrans.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ReportTemplateAreaTrans>) instances;
    }


	/**
	 * Gets a {@link List} of all ReportTemplateAreaTrans instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ReportTemplateAreaTrans> findByExample(ReportTemplateAreaTrans instance) {
        logger.debug("finding ReportTemplateAreaTrans instance by example");
        List<ReportTemplateAreaTrans> results = (List<ReportTemplateAreaTrans>) getSession()
                .createCriteria(ReportTemplateAreaTrans.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ReportTemplateAreaTrans instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportTemplateAreaTrans> findByFieldParcial(ReportTemplateAreaTrans.Fields field, String value) {
        logger.debug("finding ReportTemplateAreaTrans instance by parcial value: "+field+" like "+value);
        List<ReportTemplateAreaTrans> results = (List<ReportTemplateAreaTrans>) getSession()
                .createCriteria(ReportTemplateAreaTrans.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all ReportTemplateAreaTrans instances
	 * in the persistence layer than match the language attribute with the given value
	 *
	 * @param language to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplateAreaTrans> findByLanguage(String language) {
        ReportTemplateAreaTrans instance = new ReportTemplateAreaTrans();

        instance.setLanguage(language);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportTemplateAreaTrans instances
	 * in the persistence layer than match the content attribute with the given value
	 *
	 * @param content to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplateAreaTrans> findByContent(String content) {
        ReportTemplateAreaTrans instance = new ReportTemplateAreaTrans();

        instance.setContent(content);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportTemplateAreaTrans instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplateAreaTrans> findByTitle(String title) {
        ReportTemplateAreaTrans instance = new ReportTemplateAreaTrans();

        instance.setTitle(title);

        return findByExample(instance);
    }

}

