package pt.digitalis.dif.dem.managers.impl.model.data;


import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;

/**
 * EcommercePayments
 * Generated on ORM Generator
 * DIF build process for the Model layer
 *
 */
@SuppressWarnings("serial")
public class EcommercePayments extends AbstractBeanRelationsAttributes implements java.io.Serializable {

    /** EcommercePayments attributes enumeration */
    public static class Fields {
        /** id column */
        public static final String ID = "id";
        /** businessId column */
        public static final String BUSINESSID = "businessId";
        /** transactionId column */
        public static final String TRANSACTIONID = "transactionId";
        /** creator column */
        public static final String CREATOR = "creator";
        /** businessContext column */
        public static final String BUSINESSCONTEXT = "businessContext";
        /** ecommerceProcessor column */
        public static final String ECOMMERCEPROCESSOR = "ecommerceProcessor";
        /** paymentValue column */
        public static final String PAYMENTVALUE = "paymentValue";
        /** status column */
        public static final String STATUS = "status";
        /** statusMessage column */
        public static final String STATUSMESSAGE = "statusMessage";
        /** securityToken column */
        public static final String SECURITYTOKEN = "securityToken";
        /** dateCreation column */
        public static final String DATECREATION = "dateCreation";
        /** dateReceived column */
        public static final String DATERECEIVED = "dateReceived";
        /** dateProcessed column */
        public static final String DATEPROCESSED = "dateProcessed";
        /** transactionDate column */
        public static final String TRANSACTIONDATE = "transactionDate";
        /** authorizationId column */
        public static final String AUTHORIZATIONID = "authorizationId";
        /** redirectUrl column */
        public static final String REDIRECTURL = "redirectUrl";
        /** configurationId column */
        public static final String CONFIGURATIONID = "configurationId";
        /** sentOnReport column */
        public static final String SENTONREPORT = "sentOnReport";
        /** paymentContext column */
        public static final String PAYMENTCONTEXT = "paymentContext";

	    /**
          * List of existing fields
	     *
	     * @return list of field names
	     */
        public static List<String> values() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("businessId");
            list.add("transactionId");
            list.add("creator");
            list.add("businessContext");
            list.add("ecommerceProcessor");
            list.add("paymentValue");
            list.add("status");
            list.add("statusMessage");
            list.add("securityToken");
            list.add("dateCreation");
            list.add("dateReceived");
            list.add("dateProcessed");
            list.add("transactionDate");
            list.add("authorizationId");
            list.add("redirectUrl");
            list.add("configurationId");
            list.add("sentOnReport");
            list.add("paymentContext");

            return list;
        }
    }

	/**
 	 * The Class Relations.
 	 */
	 public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations {

        /**
         * Instantiates a new relations.
         *
         * @param currentPath
         *            the current path
         */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
		/**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
		/**
         * the BUSINESSID path.
         *
         * @return the path
         */
        public String BUSINESSID()
        {
            return buildPath(Fields.BUSINESSID);
        }
		/**
         * the TRANSACTIONID path.
         *
         * @return the path
         */
        public String TRANSACTIONID()
        {
            return buildPath(Fields.TRANSACTIONID);
        }
		/**
         * the CREATOR path.
         *
         * @return the path
         */
        public String CREATOR()
        {
            return buildPath(Fields.CREATOR);
        }
		/**
         * the BUSINESSCONTEXT path.
         *
         * @return the path
         */
        public String BUSINESSCONTEXT()
        {
            return buildPath(Fields.BUSINESSCONTEXT);
        }
		/**
         * the ECOMMERCEPROCESSOR path.
         *
         * @return the path
         */
        public String ECOMMERCEPROCESSOR()
        {
            return buildPath(Fields.ECOMMERCEPROCESSOR);
        }
		/**
         * the PAYMENTVALUE path.
         *
         * @return the path
         */
        public String PAYMENTVALUE()
        {
            return buildPath(Fields.PAYMENTVALUE);
        }
		/**
         * the STATUS path.
         *
         * @return the path
         */
        public String STATUS()
        {
            return buildPath(Fields.STATUS);
        }
		/**
         * the STATUSMESSAGE path.
         *
         * @return the path
         */
        public String STATUSMESSAGE()
        {
            return buildPath(Fields.STATUSMESSAGE);
        }
		/**
         * the SECURITYTOKEN path.
         *
         * @return the path
         */
        public String SECURITYTOKEN()
        {
            return buildPath(Fields.SECURITYTOKEN);
        }
		/**
         * the DATECREATION path.
         *
         * @return the path
         */
        public String DATECREATION()
        {
            return buildPath(Fields.DATECREATION);
        }
		/**
         * the DATERECEIVED path.
         *
         * @return the path
         */
        public String DATERECEIVED()
        {
            return buildPath(Fields.DATERECEIVED);
        }
		/**
         * the DATEPROCESSED path.
         *
         * @return the path
         */
        public String DATEPROCESSED()
        {
            return buildPath(Fields.DATEPROCESSED);
        }
		/**
         * the TRANSACTIONDATE path.
         *
         * @return the path
         */
        public String TRANSACTIONDATE()
        {
            return buildPath(Fields.TRANSACTIONDATE);
        }
		/**
         * the AUTHORIZATIONID path.
         *
         * @return the path
         */
        public String AUTHORIZATIONID()
        {
            return buildPath(Fields.AUTHORIZATIONID);
        }
		/**
         * the REDIRECTURL path.
         *
         * @return the path
         */
        public String REDIRECTURL()
        {
            return buildPath(Fields.REDIRECTURL);
        }
		/**
         * the CONFIGURATIONID path.
         *
         * @return the path
         */
        public String CONFIGURATIONID()
        {
            return buildPath(Fields.CONFIGURATIONID);
        }
		/**
         * the SENTONREPORT path.
         *
         * @return the path
         */
        public String SENTONREPORT()
        {
            return buildPath(Fields.SENTONREPORT);
        }
		/**
         * the PAYMENTCONTEXT path.
         *
         * @return the path
         */
        public String PAYMENTCONTEXT()
        {
            return buildPath(Fields.PAYMENTCONTEXT);
        }
    }
	
	/** The dummy obj. */
    private static EcommercePayments dummyObj = new EcommercePayments();

	/**
     * Get EcommercePayments Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    protected Object getAttributeNoGraphNavigation(String attributeName) {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("businessId".equalsIgnoreCase(attributeName))
            return businessId;
        if ("transactionId".equalsIgnoreCase(attributeName))
            return transactionId;
        if ("creator".equalsIgnoreCase(attributeName))
            return creator;
        if ("businessContext".equalsIgnoreCase(attributeName))
            return businessContext;
        if ("ecommerceProcessor".equalsIgnoreCase(attributeName))
            return ecommerceProcessor;
        if ("paymentValue".equalsIgnoreCase(attributeName))
            return paymentValue;
        if ("status".equalsIgnoreCase(attributeName))
            return status;
        if ("statusMessage".equalsIgnoreCase(attributeName))
            return statusMessage;
        if ("securityToken".equalsIgnoreCase(attributeName))
            return securityToken;
        if ("dateCreation".equalsIgnoreCase(attributeName))
            return dateCreation;
        if ("dateReceived".equalsIgnoreCase(attributeName))
            return dateReceived;
        if ("dateProcessed".equalsIgnoreCase(attributeName))
            return dateProcessed;
        if ("transactionDate".equalsIgnoreCase(attributeName))
            return transactionDate;
        if ("authorizationId".equalsIgnoreCase(attributeName))
            return authorizationId;
        if ("redirectUrl".equalsIgnoreCase(attributeName))
            return redirectUrl;
        if ("configurationId".equalsIgnoreCase(attributeName))
            return configurationId;
        if ("sentOnReport".equalsIgnoreCase(attributeName))
            return sentOnReport;
        if ("paymentContext".equalsIgnoreCase(attributeName))
            return paymentContext;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue) {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long)attributeValue;
        if ("businessId".equalsIgnoreCase(attributeName))
            businessId = (String)attributeValue;
        if ("transactionId".equalsIgnoreCase(attributeName))
            transactionId = (String)attributeValue;
        if ("creator".equalsIgnoreCase(attributeName))
            creator = (String)attributeValue;
        if ("businessContext".equalsIgnoreCase(attributeName))
            businessContext = (String)attributeValue;
        if ("ecommerceProcessor".equalsIgnoreCase(attributeName))
            ecommerceProcessor = (String)attributeValue;
        if ("paymentValue".equalsIgnoreCase(attributeName))
            paymentValue = (BigDecimal)attributeValue;
        if ("status".equalsIgnoreCase(attributeName))
            status = (String)attributeValue;
        if ("statusMessage".equalsIgnoreCase(attributeName))
            statusMessage = (String)attributeValue;
        if ("securityToken".equalsIgnoreCase(attributeName))
            securityToken = (String)attributeValue;
        if ("dateCreation".equalsIgnoreCase(attributeName))
            dateCreation = (Timestamp)attributeValue;
        if ("dateReceived".equalsIgnoreCase(attributeName))
            dateReceived = (Timestamp)attributeValue;
        if ("dateProcessed".equalsIgnoreCase(attributeName))
            dateProcessed = (Timestamp)attributeValue;
        if ("transactionDate".equalsIgnoreCase(attributeName))
            transactionDate = (Timestamp)attributeValue;
        if ("authorizationId".equalsIgnoreCase(attributeName))
            authorizationId = (String)attributeValue;
        if ("redirectUrl".equalsIgnoreCase(attributeName))
            redirectUrl = (String)attributeValue;
        if ("configurationId".equalsIgnoreCase(attributeName))
            configurationId = (String)attributeValue;
        if ("sentOnReport".equalsIgnoreCase(attributeName))
            sentOnReport = (Boolean)attributeValue;
        if ("paymentContext".equalsIgnoreCase(attributeName))
            paymentContext = (String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** businessId private attribute */
    private String businessId;

    /** transactionId private attribute */
    private String transactionId;

    /** creator private attribute */
    private String creator;

    /** businessContext private attribute */
    private String businessContext;

    /** ecommerceProcessor private attribute */
    private String ecommerceProcessor;

    /** paymentValue private attribute */
    private BigDecimal paymentValue;

    /** status private attribute */
    private String status;

    /** statusMessage private attribute */
    private String statusMessage;

    /** securityToken private attribute */
    private String securityToken;

    /** dateCreation private attribute */
    private Timestamp dateCreation;

    /** dateReceived private attribute */
    private Timestamp dateReceived;

    /** dateProcessed private attribute */
    private Timestamp dateProcessed;

    /** transactionDate private attribute */
    private Timestamp transactionDate;

    /** authorizationId private attribute */
    private String authorizationId;

    /** redirectUrl private attribute */
    private String redirectUrl;

    /** configurationId private attribute */
    private String configurationId;

    /** sentOnReport private attribute */
    private boolean sentOnReport;

    /** paymentContext private attribute */
    private String paymentContext;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public EcommercePayments() {
    }

	/** 
	 * minimal constructor
	 *
     * @param sentOnReport
    }
	 */
    public EcommercePayments(boolean sentOnReport) {
        this.sentOnReport = sentOnReport;
    }

    /**
     * full constructor
	 *
     * @param businessId
     * @param transactionId
     * @param creator
     * @param businessContext
     * @param ecommerceProcessor
     * @param paymentValue
     * @param status
     * @param statusMessage
     * @param securityToken
     * @param dateCreation
     * @param dateReceived
     * @param dateProcessed
     * @param transactionDate
     * @param authorizationId
     * @param redirectUrl
     * @param configurationId
     * @param sentOnReport
     * @param paymentContext
     */
    public EcommercePayments(String businessId, String transactionId, String creator, String businessContext, String ecommerceProcessor, BigDecimal paymentValue, String status, String statusMessage, String securityToken, Timestamp dateCreation, Timestamp dateReceived, Timestamp dateProcessed, Timestamp transactionDate, String authorizationId, String redirectUrl, String configurationId, boolean sentOnReport, String paymentContext) {
        this.businessId = businessId;
        this.transactionId = transactionId;
        this.creator = creator;
        this.businessContext = businessContext;
        this.ecommerceProcessor = ecommerceProcessor;
        this.paymentValue = paymentValue;
        this.status = status;
        this.statusMessage = statusMessage;
        this.securityToken = securityToken;
        this.dateCreation = dateCreation;
        this.dateReceived = dateReceived;
        this.dateProcessed = dateProcessed;
        this.transactionDate = transactionDate;
        this.authorizationId = authorizationId;
        this.redirectUrl = redirectUrl;
        this.configurationId = configurationId;
        this.sentOnReport = sentOnReport;
        this.paymentContext = paymentContext;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * businessId getter method
     *
     * @return businessId method
     */
    public String getBusinessId() {
        return this.businessId;
    }
    
    /**       
     * businessId setter method
     *
     * @param businessId
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setBusinessId(String businessId) {
        this.businessId = businessId;
        
        return this;
    }
    /**       
     * transactionId getter method
     *
     * @return transactionId method
     */
    public String getTransactionId() {
        return this.transactionId;
    }
    
    /**       
     * transactionId setter method
     *
     * @param transactionId
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        
        return this;
    }
    /**       
     * creator getter method
     *
     * @return creator method
     */
    public String getCreator() {
        return this.creator;
    }
    
    /**       
     * creator setter method
     *
     * @param creator
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setCreator(String creator) {
        this.creator = creator;
        
        return this;
    }
    /**       
     * businessContext getter method
     *
     * @return businessContext method
     */
    public String getBusinessContext() {
        return this.businessContext;
    }
    
    /**       
     * businessContext setter method
     *
     * @param businessContext
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setBusinessContext(String businessContext) {
        this.businessContext = businessContext;
        
        return this;
    }
    /**       
     * ecommerceProcessor getter method
     *
     * @return ecommerceProcessor method
     */
    public String getEcommerceProcessor() {
        return this.ecommerceProcessor;
    }
    
    /**       
     * ecommerceProcessor setter method
     *
     * @param ecommerceProcessor
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setEcommerceProcessor(String ecommerceProcessor) {
        this.ecommerceProcessor = ecommerceProcessor;
        
        return this;
    }
    /**       
     * paymentValue getter method
     *
     * @return paymentValue method
     */
    public BigDecimal getPaymentValue() {
        return this.paymentValue;
    }
    
    /**       
     * paymentValue setter method
     *
     * @param paymentValue
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setPaymentValue(BigDecimal paymentValue) {
        this.paymentValue = paymentValue;
        
        return this;
    }
    /**       
     * status getter method
     *
     * @return status method
     */
    public String getStatus() {
        return this.status;
    }
    
    /**       
     * status setter method
     *
     * @param status
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setStatus(String status) {
        this.status = status;
        
        return this;
    }
    /**       
     * statusMessage getter method
     *
     * @return statusMessage method
     */
    public String getStatusMessage() {
        return this.statusMessage;
    }
    
    /**       
     * statusMessage setter method
     *
     * @param statusMessage
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        
        return this;
    }
    /**       
     * securityToken getter method
     *
     * @return securityToken method
     */
    public String getSecurityToken() {
        return this.securityToken;
    }
    
    /**       
     * securityToken setter method
     *
     * @param securityToken
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
        
        return this;
    }
    /**       
     * dateCreation getter method
     *
     * @return dateCreation method
     */
    public Timestamp getDateCreation() {
        return this.dateCreation;
    }
    
    /**       
     * dateCreation setter method
     *
     * @param dateCreation
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setDateCreation(Timestamp dateCreation) {
        this.dateCreation = dateCreation;
        
        return this;
    }
    /**       
     * dateReceived getter method
     *
     * @return dateReceived method
     */
    public Timestamp getDateReceived() {
        return this.dateReceived;
    }
    
    /**       
     * dateReceived setter method
     *
     * @param dateReceived
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setDateReceived(Timestamp dateReceived) {
        this.dateReceived = dateReceived;
        
        return this;
    }
    /**       
     * dateProcessed getter method
     *
     * @return dateProcessed method
     */
    public Timestamp getDateProcessed() {
        return this.dateProcessed;
    }
    
    /**       
     * dateProcessed setter method
     *
     * @param dateProcessed
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setDateProcessed(Timestamp dateProcessed) {
        this.dateProcessed = dateProcessed;
        
        return this;
    }
    /**       
     * transactionDate getter method
     *
     * @return transactionDate method
     */
    public Timestamp getTransactionDate() {
        return this.transactionDate;
    }
    
    /**       
     * transactionDate setter method
     *
     * @param transactionDate
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setTransactionDate(Timestamp transactionDate) {
        this.transactionDate = transactionDate;
        
        return this;
    }
    /**       
     * authorizationId getter method
     *
     * @return authorizationId method
     */
    public String getAuthorizationId() {
        return this.authorizationId;
    }
    
    /**       
     * authorizationId setter method
     *
     * @param authorizationId
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
        
        return this;
    }
    /**       
     * redirectUrl getter method
     *
     * @return redirectUrl method
     */
    public String getRedirectUrl() {
        return this.redirectUrl;
    }
    
    /**       
     * redirectUrl setter method
     *
     * @param redirectUrl
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        
        return this;
    }
    /**       
     * configurationId getter method
     *
     * @return configurationId method
     */
    public String getConfigurationId() {
        return this.configurationId;
    }
    
    /**       
     * configurationId setter method
     *
     * @param configurationId
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setConfigurationId(String configurationId) {
        this.configurationId = configurationId;
        
        return this;
    }
    /**       
     * sentOnReport getter method
     *
     * @return sentOnReport method
     */
    public boolean isSentOnReport() {
        return this.sentOnReport;
    }
    
    /**       
     * sentOnReport setter method
     *
     * @param sentOnReport
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setSentOnReport(boolean sentOnReport) {
        this.sentOnReport = sentOnReport;
        
        return this;
    }
    /**       
     * paymentContext getter method
     *
     * @return paymentContext method
     */
    public String getPaymentContext() {
        return this.paymentContext;
    }
    
    /**       
     * paymentContext setter method
     *
     * @param paymentContext
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setPaymentContext(String paymentContext) {
        this.paymentContext = paymentContext;
        
        return this;
    }

    /**
     * Creates a String representation of the EcommercePayments object
     *
     * @return the compiled String
     */
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("businessId").append("='").append(getBusinessId()).append("' ");			
        buffer.append("transactionId").append("='").append(getTransactionId()).append("' ");			
        buffer.append("creator").append("='").append(getCreator()).append("' ");			
        buffer.append("businessContext").append("='").append(getBusinessContext()).append("' ");			
        buffer.append("ecommerceProcessor").append("='").append(getEcommerceProcessor()).append("' ");			
        buffer.append("paymentValue").append("='").append(getPaymentValue()).append("' ");			
        buffer.append("status").append("='").append(getStatus()).append("' ");			
        buffer.append("statusMessage").append("='").append(getStatusMessage()).append("' ");			
        buffer.append("securityToken").append("='").append(getSecurityToken()).append("' ");			
        buffer.append("dateCreation").append("='").append(getDateCreation()).append("' ");			
        buffer.append("dateReceived").append("='").append(getDateReceived()).append("' ");			
        buffer.append("dateProcessed").append("='").append(getDateProcessed()).append("' ");			
        buffer.append("transactionDate").append("='").append(getTransactionDate()).append("' ");			
        buffer.append("authorizationId").append("='").append(getAuthorizationId()).append("' ");			
        buffer.append("redirectUrl").append("='").append(getRedirectUrl()).append("' ");			
        buffer.append("configurationId").append("='").append(getConfigurationId()).append("' ");			
        buffer.append("sentOnReport").append("='").append(isSentOnReport()).append("' ");			
        buffer.append("paymentContext").append("='").append(getPaymentContext()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the EcommercePayments object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(EcommercePayments other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("businessId".equalsIgnoreCase(attributeName))
        	this.businessId = attributeValue;

        if ("transactionId".equalsIgnoreCase(attributeName))
        	this.transactionId = attributeValue;

        if ("creator".equalsIgnoreCase(attributeName))
        	this.creator = attributeValue;

        if ("businessContext".equalsIgnoreCase(attributeName))
        	this.businessContext = attributeValue;

        if ("ecommerceProcessor".equalsIgnoreCase(attributeName))
        	this.ecommerceProcessor = attributeValue;

        if ("paymentValue".equalsIgnoreCase(attributeName))
	        this.paymentValue = new BigDecimal(attributeValue);

        if ("status".equalsIgnoreCase(attributeName))
        	this.status = attributeValue;

        if ("statusMessage".equalsIgnoreCase(attributeName))
        	this.statusMessage = attributeValue;

        if ("securityToken".equalsIgnoreCase(attributeName))
        	this.securityToken = attributeValue;

        if ("dateCreation".equalsIgnoreCase(attributeName))
            this.dateCreation = Timestamp.valueOf(attributeValue);

        if ("dateReceived".equalsIgnoreCase(attributeName))
            this.dateReceived = Timestamp.valueOf(attributeValue);

        if ("dateProcessed".equalsIgnoreCase(attributeName))
            this.dateProcessed = Timestamp.valueOf(attributeValue);

        if ("transactionDate".equalsIgnoreCase(attributeName))
            this.transactionDate = Timestamp.valueOf(attributeValue);

        if ("authorizationId".equalsIgnoreCase(attributeName))
        	this.authorizationId = attributeValue;

        if ("redirectUrl".equalsIgnoreCase(attributeName))
        	this.redirectUrl = attributeValue;

        if ("configurationId".equalsIgnoreCase(attributeName))
        	this.configurationId = attributeValue;

        if ("sentOnReport".equalsIgnoreCase(attributeName))
            this.sentOnReport = Boolean.valueOf(attributeValue);

        if ("paymentContext".equalsIgnoreCase(attributeName))
        	this.paymentContext = attributeValue;

    }


}
