/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoDashboardDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Dashboard;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoDashboardDAOImpl
implements IAutoDashboardDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Dashboard> getDashboardDataSet() {
        return new HibernateDataSet(Dashboard.class, (IHibernateDAO)this, Dashboard.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(Dashboard transientInstance) {
        this.logger.debug((Object)"persisting Dashboard instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Dashboard instance) {
        this.logger.debug((Object)"attaching dirty Dashboard instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Dashboard instance) {
        this.logger.debug((Object)"attaching clean Dashboard instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Dashboard persistentInstance) {
        this.logger.debug((Object)"deleting Dashboard instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Dashboard merge(Dashboard detachedInstance) {
        this.logger.debug((Object)"merging Dashboard instance");
        Dashboard result = (Dashboard)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Dashboard findById(Long id) {
        this.logger.debug((Object)("getting Dashboard instance with id: " + id));
        Dashboard instance = (Dashboard)this.getSession().get(Dashboard.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Dashboard> findAll() {
        List<Dashboard> instances = new ArrayList();
        this.logger.debug((Object)"getting all Dashboard instances");
        instances = this.getSession().createCriteria(Dashboard.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Dashboard> findByExample(Dashboard instance) {
        this.logger.debug((Object)"finding Dashboard instance by example");
        List results = this.getSession().createCriteria(Dashboard.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Dashboard> findByFieldParcial(Dashboard.Fields field, String value) {
        this.logger.debug((Object)("finding Dashboard instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Dashboard.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Dashboard> findByUniqueId(String uniqueId) {
        Dashboard instance = new Dashboard();
        instance.setUniqueId(uniqueId);
        return this.findByExample(instance);
    }

    @Override
    public List<Dashboard> findByTitle(String title) {
        Dashboard instance = new Dashboard();
        instance.setTitle(title);
        return this.findByExample(instance);
    }

    @Override
    public List<Dashboard> findByTemplate(String template) {
        Dashboard instance = new Dashboard();
        instance.setTemplate(template);
        return this.findByExample(instance);
    }
}

