/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.ddm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.hibernate.Session;
import pt.digitalis.dif.dataminer.definition.ChartType;
import pt.digitalis.dif.dataminer.definition.DashboardManager;
import pt.digitalis.dif.dataminer.definition.FilterType;
import pt.digitalis.dif.dataminer.definition.IDashboardPersistence;
import pt.digitalis.dif.dataminer.definition.IIndicator;
import pt.digitalis.dif.dataminer.definition.IIndicatorSQL;
import pt.digitalis.dif.dataminer.definition.Series;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.data.Area;
import pt.digitalis.dif.dem.managers.impl.model.data.Filter;
import pt.digitalis.dif.dem.managers.impl.model.data.Indicator;
import pt.digitalis.dif.dem.managers.impl.model.data.Manager;
import pt.digitalis.dif.dem.managers.impl.model.data.Serie;
import pt.digitalis.dif.dem.managers.impl.model.impl.DDMServiceImpl;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.NumericUtils;
import pt.digitalis.utils.common.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardPersistenceBDImpl
implements IDashboardPersistence {
    protected Map<String, String> fromJSONToMap(String jsonRepresentation) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonRepresentation);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = jsonObject.getString(key);
            dataMap.put(key, value);
        }
        return dataMap;
    }

    protected Area getOrCreateAreaDB(IIndicator indicator) throws DataSetException {
        DDMServiceImpl ddmDB = new DDMServiceImpl();
        IDataSet<Area> areaDataset = ddmDB.getAreaDataSet();
        Area areaDB = (Area)areaDataset.query().equals("uniqueId", indicator.getAreaID()).singleValue();
        if (areaDB == null) {
            DashboardManager manager = DashboardManager.getInstance((String)indicator.getManagerID());
            pt.digitalis.dif.dataminer.definition.Area area = (pt.digitalis.dif.dataminer.definition.Area)manager.getAreas().get(indicator.getAreaID());
            areaDB = new Area();
            areaDB.setUniqueId(indicator.getAreaID());
            areaDB.setTitle(area.getTitle());
            areaDB.setDatabasePass(area.getDatabasePassword());
            areaDB.setDatabaseUrl(area.getDatabaseURL());
            areaDB.setDatabaseUser(area.getDatabaseUsername());
            areaDB.setManager(this.getOrCreateManagerDB(manager));
            areaDB = (Area)areaDataset.insert((IBeanAttributes)areaDB);
        }
        return areaDB;
    }

    private Manager getOrCreateManagerDB(DashboardManager manager) throws DataSetException {
        DDMServiceImpl ddmDB = new DDMServiceImpl();
        IDataSet<Manager> managerDataset = ddmDB.getManagerDataSet();
        Manager managerDB = (Manager)managerDataset.query().equals("uniqueId", manager.getId()).singleValue();
        if (managerDB == null) {
            managerDB = new Manager();
            managerDB.setUniqueId(manager.getId());
            managerDB = (Manager)managerDataset.insert((IBeanAttributes)managerDB);
        }
        return managerDB;
    }

    public boolean isAvailable() {
        return true;
    }

    protected void loadAreaFromDB(Area areaDB, pt.digitalis.dif.dataminer.definition.Area area, DashboardManager dashboardManager) {
        if (StringUtils.isNotBlank((String)areaDB.getRestrictGroups())) {
            area.setDefaultGroupsToRestrict(Arrays.asList(areaDB.getRestrictGroups().split(",")));
        } else {
            area.setDefaultGroupsToRestrict(null);
        }
        if (StringUtils.isNotBlank((String)areaDB.getRestrictProfiles())) {
            area.setDefaultProfilesToRestrict(Arrays.asList(areaDB.getRestrictProfiles().split(",")));
        } else {
            area.setDefaultProfilesToRestrict(null);
        }
    }

    public DashboardManager loadConfigurations(DashboardManager dashboardManager) throws BusinessException {
        try {
            int customizedAreas = 0;
            int customizedIndicators = 0;
            int userIndicators = 0;
            DIFLogger.getLogger().info((Object)("Loading Dashboard Manager \"" + dashboardManager.getId() + "\" (" + dashboardManager.getTotalIndicators() + " indicator(s) in " + dashboardManager.getTotalAreas() + " area(s))"));
            DDMServiceImpl ddmDB = new DDMServiceImpl();
            Query queryAreas = ddmDB.getAreaDataSet().query().equals(Area.FK().manager().UNIQUEID(), dashboardManager.getId());
            for (Area areaDB : queryAreas.asList()) {
                DIFLogger.getLogger().debug((Object)("  - Customized area [" + areaDB.getId() + "] " + areaDB.getUniqueId() + " - " + areaDB.getTitle()));
                ++customizedAreas;
                pt.digitalis.dif.dataminer.definition.Area area = (pt.digitalis.dif.dataminer.definition.Area)dashboardManager.getAreas().get(areaDB.getUniqueId());
                this.loadAreaFromDB(areaDB, area, dashboardManager);
            }
            Query queryIndicators = ddmDB.getIndicatorDataSet().query().equals(Indicator.FK().area().manager().UNIQUEID(), dashboardManager.getId()).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Indicator.FK().series(), JoinType.LEFT_OUTER_JOIN).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Indicator.FK().filters(), JoinType.LEFT_OUTER_JOIN);
            queryIndicators.setDistinctEntities(true);
            for (Indicator indicatorDB : queryIndicators.asList()) {
                IIndicator indicator;
                boolean customization = DEFINITION_TYPES.CUSTOMIZATION.getDBRepresentation().equals(indicatorDB.getDefinitionType());
                DIFLogger.getLogger().debug((Object)("  - " + (customization ? "Customized" : "User defined") + " indicator [" + indicatorDB.getId() + "] " + indicatorDB.getUniqueId() + " - " + indicatorDB.getTitle()));
                if (DEFINITION_TYPES.CUSTOMIZATION.getDBRepresentation().equals(indicatorDB.getDefinitionType())) {
                    ++customizedIndicators;
                } else {
                    ++userIndicators;
                }
                pt.digitalis.dif.dataminer.definition.Area area = (pt.digitalis.dif.dataminer.definition.Area)dashboardManager.getAreas().get(indicatorDB.getArea().getUniqueId());
                if (customization) {
                    indicator = (IIndicator)area.getIndicators().get(indicatorDB.getUniqueId());
                    this.loadIndicatorFromDB(indicatorDB, indicator, dashboardManager);
                    continue;
                }
                indicator = (IIndicator)DIFIoCRegistry.getRegistry().getImplementation(IIndicatorSQL.class);
                indicator.setAreaID(area.getId());
                indicator.setId(indicatorDB.getUniqueId());
                this.loadIndicatorFromDB(indicatorDB, indicator, dashboardManager);
                area.addIndicator(indicator);
            }
            if (customizedAreas > 0) {
                DIFLogger.getLogger().info((Object)("      " + customizedAreas + " customized areas"));
            }
            if (customizedIndicators > 0) {
                DIFLogger.getLogger().info((Object)("      " + customizedIndicators + " customized indicators"));
            }
            if (userIndicators > 0) {
                DIFLogger.getLogger().info((Object)("      " + userIndicators + " user defined indicators"));
            }
            if (customizedIndicators == 0 && userIndicators == 0) {
                DIFLogger.getLogger().info((Object)"    No customization found. Default configuration active.");
            }
        }
        catch (DataSetException e) {
            BusinessException exception = new BusinessException("Error loading dashboard customizations from the database", (Exception)((Object)e));
            exception.addToExceptionContext("Manager", (Object)dashboardManager);
            throw exception;
        }
        return dashboardManager;
    }

    protected void loadIndicatorFromDB(Indicator indicatorDB, IIndicator indicator, DashboardManager dashboardManager) {
        indicator.setAutoRefreshInterval(indicatorDB.getAutoRefreshInt());
        indicator.setxAxisTitle(indicatorDB.getAxisXTitle());
        indicator.setyAxisTitle(indicatorDB.getAxisYTitle());
        indicator.setOrigyn(DEFINITION_TYPES.indicatorOrigynForPersistanceDefinition(indicatorDB.getDefinitionType()));
        indicator.setDescription(indicatorDB.getDescription());
        indicator.setDescriptionTitle(indicatorDB.getDescriptionTitle());
        indicator.setGroupTitle(indicatorDB.getGroupTitle());
        indicator.setHideMarkers(indicatorDB.isHideMarkers());
        indicator.setLegend(indicatorDB.isLegend());
        indicator.setLimitTopRecords(indicatorDB.getLimitTopRecords() == null ? null : Integer.valueOf(indicatorDB.getLimitTopRecords().intValue()));
        indicator.setMaxValue(indicatorDB.getMaxValue());
        if (StringUtils.isNotBlank((String)indicatorDB.getRestrictGroups())) {
            indicator.setRestrictToGroups(Arrays.asList(indicatorDB.getRestrictGroups().split(",")));
        }
        if (StringUtils.isNotBlank((String)indicatorDB.getRestrictProfiles())) {
            indicator.setRestrictToProfiles(Arrays.asList(indicatorDB.getRestrictProfiles().split(",")));
        }
        indicator.setTimeKeys(indicatorDB.isTimeKeys());
        indicator.setTitle(indicatorDB.getTitle());
        indicator.setHasTotalField(indicatorDB.isTotalField());
        indicator.setUnitSuffix(indicatorDB.getUnitSuffix());
        indicator.setUseMinutes(indicatorDB.isUseMinutes());
        if (indicator instanceof IIndicatorSQL) {
            IIndicatorSQL sqlIndicator = (IIndicatorSQL)indicator;
            sqlIndicator.setQuerySQL(indicatorDB.getQuerySql());
            sqlIndicator.setMaterializedViews(indicatorDB.getViewsToRefresh());
        }
        HashMap<String, Series> seriesByValueField = new HashMap<String, Series>();
        for (Series serie : indicator.getSeries()) {
            seriesByValueField.put(serie.getValueField(), serie);
        }
        HashMap<String, Serie> seriesBDByValueField = new HashMap<String, Serie>();
        for (Serie serie : indicatorDB.getSeries()) {
            seriesBDByValueField.put(serie.getValueField(), serie);
        }
        for (Serie serie : seriesByValueField.values()) {
            if (seriesBDByValueField.containsKey(serie.getValueField())) continue;
            indicator.getSeries().remove(serie);
        }
        for (Serie serieDB : indicatorDB.getSeries()) {
            Series serie = (Series)seriesByValueField.get(serieDB.getValueField());
            if (serie != null) {
                serie.setDescription(serieDB.getDescription());
                serie.setChartType(ChartType.fromCharacterRepresentation((Character)serieDB.getType()));
                serie.setUnitName(serieDB.getUnitName());
                continue;
            }
            serie = new Series(ChartType.fromCharacterRepresentation((Character)serieDB.getType()), serieDB.getUnitName(), serieDB.getDescription(), serieDB.getValueField());
            indicator.getSeries().add(serie);
        }
        HashMap<String, pt.digitalis.dif.dataminer.definition.Filter> filtersByUniqueID = new HashMap<String, pt.digitalis.dif.dataminer.definition.Filter>();
        for (pt.digitalis.dif.dataminer.definition.Filter filter : indicator.getFilters()) {
            filtersByUniqueID.put(filter.getId(), filter);
        }
        HashMap<String, Filter> filtersDBByUniqueID = new HashMap<String, Filter>();
        for (Filter filter : indicatorDB.getFilters()) {
            filtersDBByUniqueID.put(filter.getUniqueId(), filter);
        }
        for (Filter filter : filtersByUniqueID.values()) {
            if (filtersDBByUniqueID.get(filter.getId()) != null) continue;
            indicator.getFilters().remove(filtersDBByUniqueID.get(filter.getId()));
        }
        for (Filter filterDB : indicatorDB.getFilters()) {
            pt.digitalis.dif.dataminer.definition.Filter filter = (pt.digitalis.dif.dataminer.definition.Filter)filtersByUniqueID.get(filterDB.getUniqueId());
            boolean newFilter = false;
            if (filter == null) {
                newFilter = true;
                filter = new pt.digitalis.dif.dataminer.definition.Filter(filterDB.getUniqueId(), FilterType.fromCharacterRepresentation((Character)filterDB.getType()), filterDB.getTitle(), filterDB.getDescription(), filterDB.getSqlTemplate());
            }
            filter.setType(FilterType.fromCharacterRepresentation((Character)filterDB.getType()));
            filter.setBindToProfileID(filterDB.getBindToProfile());
            filter.setDefaultValue(filterDB.getDefaultValue());
            filter.setDescription(filterDB.getDescription());
            if (StringUtils.isNotBlank((String)filterDB.getItemsList())) {
                filter.setLovItems(this.fromJSONToMap(filterDB.getItemsList()));
            }
            filter.setLovQuerySQL(filterDB.getItemsQuerySql());
            filter.setFilterSQLTemplate(filterDB.getSqlTemplate());
            filter.setTitle(filterDB.getTitle());
            if (!newFilter) continue;
            indicator.getFilters().add(filter);
        }
    }

    public void removeIndicatorConfiguration(IIndicator indicator) throws BusinessException {
        this.removeIndicatorConfiguration(indicator.getId());
    }

    public void removeIndicatorConfiguration(String indicatorID) throws BusinessException {
        try {
            DDMServiceImpl ddmDB = new DDMServiceImpl();
            IDataSet<Indicator> ds = ddmDB.getIndicatorDataSet();
            Indicator indicatorDB = (Indicator)ds.query().equals("uniqueId", indicatorID).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Indicator.FK().series(), JoinType.LEFT_OUTER_JOIN).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Indicator.FK().filters(), JoinType.LEFT_OUTER_JOIN).singleValue();
            if (indicatorDB != null) {
                for (Serie serie : indicatorDB.getSeries()) {
                    ddmDB.getSerieDataSet().delete(serie.getId().toString());
                }
                for (Filter filter : indicatorDB.getFilters()) {
                    ddmDB.getFilterDataSet().delete(filter.getId().toString());
                }
                ds.delete(indicatorDB.getId().toString());
            }
        }
        catch (DataSetException e) {
            BusinessException exception = new BusinessException("Error deleting indicator customization from the database", (Exception)((Object)e));
            exception.addToExceptionContext("Indicator ID", (Object)indicatorID);
            throw exception;
        }
    }

    public void saveAreaConfiguration(pt.digitalis.dif.dataminer.definition.Area area) throws BusinessException {
        try {
            Area areaDB;
            boolean transactionWasActive;
            DDMServiceImpl ddmDB = new DDMServiceImpl();
            IDataSet<Area> ds = ddmDB.getAreaDataSet();
            boolean newRecord = false;
            Session session = DIFRepositoryFactory.getSession();
            boolean bl = transactionWasActive = session.getTransaction() != null && session.getTransaction().isActive();
            if (!transactionWasActive) {
                session.beginTransaction();
            }
            if ((areaDB = (Area)ds.query().equals("uniqueId", area.getId()).singleValue()) == null) {
                newRecord = true;
                areaDB = new Area();
                areaDB.setUniqueId(area.getId());
                areaDB.setDatabasePass(area.getDatabasePassword());
                areaDB.setDatabaseUrl(area.getDatabaseURL());
                areaDB.setDatabaseUser(area.getDatabaseUsername());
                areaDB.setManager(this.getOrCreateManagerDB(DashboardManager.getInstance((String)area.getManagerID())));
            }
            areaDB.setTitle(area.getTitle());
            if (area.getDefaultGroupsToRestrict() != null) {
                areaDB.setRestrictGroups(CollectionUtils.listToCommaSeparatedString((List)area.getDefaultGroupsToRestrict()));
            } else {
                areaDB.setRestrictGroups(null);
            }
            if (area.getDefaultProfilesToRestrict() != null) {
                areaDB.setRestrictProfiles(CollectionUtils.listToCommaSeparatedString((List)area.getDefaultProfilesToRestrict()));
            } else {
                areaDB.setRestrictProfiles(null);
            }
            if (newRecord) {
                areaDB = (Area)ds.insert((IBeanAttributes)areaDB);
            } else {
                ds.update((IBeanAttributes)areaDB);
            }
            if (!transactionWasActive) {
                session.getTransaction().commit();
            }
        }
        catch (DataSetException e) {
            BusinessException exception = new BusinessException("Error saving area customizations to the database", (Exception)((Object)e));
            exception.addToExceptionContext("Area", (Object)area);
            throw exception;
        }
    }

    public void saveIndicatorConfiguration(IIndicator indicator) throws BusinessException {
        try {
            Indicator indicatorDB;
            boolean transactionWasActive;
            DDMServiceImpl ddmDB = new DDMServiceImpl();
            IDataSet<Indicator> ds = ddmDB.getIndicatorDataSet();
            boolean newRecord = false;
            Session session = DIFRepositoryFactory.getSession();
            boolean bl = transactionWasActive = session.getTransaction() != null && session.getTransaction().isActive();
            if (!transactionWasActive) {
                session.beginTransaction();
            }
            if ((indicatorDB = (Indicator)ds.query().equals("uniqueId", indicator.getId().toString()).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Indicator.FK().series(), JoinType.LEFT_OUTER_JOIN).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Indicator.FK().filters(), JoinType.LEFT_OUTER_JOIN).singleValue()) == null) {
                newRecord = true;
                indicatorDB = new Indicator();
                indicatorDB.setUniqueId(indicator.getId());
                indicatorDB.setArea(this.getOrCreateAreaDB(indicator));
            }
            indicatorDB.setAutoRefreshInt(indicator.getAutoRefreshInterval());
            indicatorDB.setAxisXTitle(indicator.getxAxisTitle());
            indicatorDB.setAxisYTitle(indicator.getyAxisTitle());
            indicatorDB.setDefinitionType(DEFINITION_TYPES.persistanceDefinitionTypeForOrigyn(indicator.getOrigyn()));
            indicatorDB.setDescription(indicator.getDescription());
            indicatorDB.setDescriptionTitle(indicator.getDescriptionTitle());
            indicatorDB.setGroupTitle(indicator.getGroupTitle());
            indicatorDB.setHideMarkers(indicator.isHideMarkers());
            indicatorDB.setLegend(indicator.isLegend());
            indicatorDB.setLimitTopRecords(NumericUtils.toLong((Number)indicator.getLimitTopRecords()));
            indicatorDB.setMaxValue(indicator.getMaxValue());
            if (indicator.getRestrictToGroups() != null) {
                indicatorDB.setRestrictGroups(CollectionUtils.listToCommaSeparatedString((List)indicator.getRestrictToGroups()));
            } else {
                indicatorDB.setRestrictGroups(null);
            }
            if (indicator.getRestrictToProfiles() != null) {
                indicatorDB.setRestrictProfiles(CollectionUtils.listToCommaSeparatedString((List)indicator.getRestrictToProfiles()));
            } else {
                indicatorDB.setRestrictProfiles(null);
            }
            indicatorDB.setTimeKeys(indicator.isTimeKeys());
            indicatorDB.setTitle(indicator.getTitle());
            indicatorDB.setTotalField(indicator.isHasTotalField());
            indicatorDB.setUnitSuffix(indicator.getUnitSuffix());
            indicatorDB.setUseMinutes(indicator.isUseMinutes());
            if (indicator instanceof IIndicatorSQL) {
                IIndicatorSQL sqlIndicator = (IIndicatorSQL)indicator;
                indicatorDB.setQuerySql(sqlIndicator.getQuerySQL());
                indicatorDB.setViewsToRefresh(sqlIndicator.getMaterializedViews());
            }
            if (newRecord) {
                indicatorDB = (Indicator)ds.insert((IBeanAttributes)indicatorDB);
            } else {
                ds.update((IBeanAttributes)indicatorDB);
            }
            HashMap<String, Series> seriesByValueField = new HashMap<String, Series>();
            for (Series serie : indicator.getSeries()) {
                seriesByValueField.put(serie.getValueField(), serie);
            }
            HashMap<String, Serie> seriesBDByValueField = new HashMap<String, Serie>();
            for (Serie serie : indicatorDB.getSeries()) {
                seriesBDByValueField.put(serie.getValueField(), serie);
            }
            if (!newRecord) {
                for (Serie serie : indicatorDB.getSeries()) {
                    if (seriesByValueField.containsKey(serie.getValueField())) continue;
                    ddmDB.getSerieDataSet().delete(serie.getId().toString());
                    seriesBDByValueField.remove(serie);
                }
            }
            for (Serie serie : indicator.getSeries()) {
                Serie serieDB = (Serie)seriesBDByValueField.get(serie.getValueField());
                if (serieDB != null) {
                    serieDB.setDescription(serie.getDescription());
                    serieDB.setType(serie.getChartType().getCharacterRepresentation());
                    serieDB.setUnitName(serie.getUnitName());
                    ddmDB.getSerieDataSet().update((IBeanAttributes)serieDB);
                    continue;
                }
                serieDB = new Serie();
                serieDB.setDescription(serie.getDescription());
                serieDB.setIndicator(indicatorDB);
                serieDB.setType(serie.getChartType().getCharacterRepresentation());
                serieDB.setUnitName(serie.getUnitName());
                serieDB.setValueField(serie.getValueField());
                serieDB = (Serie)ddmDB.getSerieDataSet().insert((IBeanAttributes)serieDB);
            }
            HashMap<String, pt.digitalis.dif.dataminer.definition.Filter> filtersByUniqueID = new HashMap<String, pt.digitalis.dif.dataminer.definition.Filter>();
            for (pt.digitalis.dif.dataminer.definition.Filter filter : indicator.getFilters()) {
                filtersByUniqueID.put(filter.getId(), filter);
            }
            HashMap<String, Filter> filtersDBByUniqueID = new HashMap<String, Filter>();
            for (Filter filter : indicatorDB.getFilters()) {
                filtersDBByUniqueID.put(filter.getUniqueId(), filter);
            }
            for (Filter filterDB : filtersDBByUniqueID.values()) {
                if (filtersByUniqueID.get(filterDB.getUniqueId()) != null) continue;
                ddmDB.getFilterDataSet().delete(filterDB.getId().toString());
                filtersDBByUniqueID.remove(filterDB);
            }
            for (Filter filter : indicator.getFilters()) {
                Filter filterDB = (Filter)filtersDBByUniqueID.get(filter.getId());
                boolean newFilter = false;
                if (filterDB == null) {
                    newFilter = true;
                    filterDB = new Filter();
                    filterDB.setUniqueId(filter.getId());
                    filterDB.setIndicator(indicatorDB);
                }
                filterDB.setType(filter.getType().getCharacterRepresentation());
                filterDB.setBindToProfile(filter.getBindToProfileID());
                filterDB.setDefaultValue(filter.getDefaultValue());
                filterDB.setDescription(filter.getDescription());
                if (filter.getLovItems() != null && !filter.getLovItems().isEmpty()) {
                    filterDB.setItemsList(JSONObject.fromObject((Object)filter.getLovItems()).toString());
                }
                filterDB.setItemsQuerySql(filter.getLovQuerySQL());
                filterDB.setSqlTemplate(filter.getFilterSQLTemplate());
                filterDB.setTitle(filter.getTitle());
                if (newFilter) {
                    ddmDB.getFilterDataSet().insert((IBeanAttributes)filterDB);
                    continue;
                }
                ddmDB.getFilterDataSet().update((IBeanAttributes)filterDB);
            }
            if (!transactionWasActive) {
                session.getTransaction().commit();
            }
        }
        catch (DataSetException e) {
            BusinessException exception = new BusinessException("Error saving indicator customizations to the database", (Exception)((Object)e));
            exception.addToExceptionContext("Indicator", (Object)indicator);
            throw exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DEFINITION_TYPES {
        CUSTOMIZATION,
        DEFINITION;


        static IIndicator.INDICATOR_ORIGINS indicatorOrigynForPersistanceDefinition(Character type) {
            if (CUSTOMIZATION.getDBRepresentation().equals(type)) {
                return IIndicator.INDICATOR_ORIGINS.APPLICATION;
            }
            return IIndicator.INDICATOR_ORIGINS.USER;
        }

        static Character persistanceDefinitionTypeForOrigyn(IIndicator.INDICATOR_ORIGINS origyn) {
            if (origyn == IIndicator.INDICATOR_ORIGINS.APPLICATION) {
                return CUSTOMIZATION.getDBRepresentation();
            }
            return DEFINITION.getDBRepresentation();
        }

        public Character getDBRepresentation() {
            if (this == CUSTOMIZATION) {
                return new Character('C');
            }
            return new Character('D');
        }
    }
}

