package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class ConfigSet.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoConfigSetDAO extends IHibernateDAO<ConfigSet> {

    /**
     * Obtains a new DataSet for the ConfigSet entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ConfigSet> getConfigSetDataSet();

	/**
	 * Persist a ConfigSet object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ConfigSet transientInstance);

	/**
	 * Updates a modified ConfigSet in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ConfigSet instance);

	/**
	 * Attach an unmodified ConfigSet instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ConfigSet instance);

	/**
	 * Removes a ConfigSet instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ConfigSet persistentInstance);

	/**
	 * Merge a ConfigSet instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ConfigSet merge(ConfigSet detachedInstance);

	/**
	 * Finds a ConfigSet instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ConfigSet findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all ConfigSet instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<ConfigSet> findAll();


	/**
	 * Gets a {@link List} of all ConfigSet instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<ConfigSet> findByFieldParcial(ConfigSet.Fields field, String value);

	/**
	 * Gets a {@link List} of all ConfigSet instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<ConfigSet> findByName(String name);

	/**
	 * Gets a {@link List} of all ConfigSet instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<ConfigSet> findByDescription(String description);
}
