package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.Configuration;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class Configuration.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Configuration
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoConfigurationDAO extends IHibernateDAO<Configuration> {

    /**
     * Obtains a new DataSet for the Configuration entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Configuration> getConfigurationDataSet();

	/**
	 * Persist a Configuration object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Configuration transientInstance);

	/**
	 * Updates a modified Configuration in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Configuration instance);

	/**
	 * Attach an unmodified Configuration instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Configuration instance);

	/**
	 * Removes a Configuration instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Configuration persistentInstance);

	/**
	 * Merge a Configuration instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Configuration merge(Configuration detachedInstance);

	/**
	 * Finds a Configuration instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Configuration findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all Configuration instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<Configuration> findAll();


	/**
	 * Gets a {@link List} of all Configuration instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<Configuration> findByFieldParcial(Configuration.Fields field, String value);

	/**
	 * Gets a {@link List} of all Configuration instances
	 * in the persistence layer than match the key attribute with the given value
	 *
	 * @param key to match
	 * @return the {@link List} of instances
	 */
    public List<Configuration> findByKey(String key);

	/**
	 * Gets a {@link List} of all Configuration instances
	 * in the persistence layer than match the value attribute with the given value
	 *
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<Configuration> findByValue(String value);

	/**
	 * Gets a {@link List} of all Configuration instances
	 * in the persistence layer than match the valueXL attribute with the given value
	 *
	 * @param valueXL to match
	 * @return the {@link List} of instances
	 */
    public List<Configuration> findByValueXL(String valueXL);
}
