package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.JasperReportTemplateFile;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoJasperReportTemplateFileDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class JasperReportTemplateFile.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.JasperReportTemplateFile
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoJasperReportTemplateFileDAOImpl implements IAutoJasperReportTemplateFileDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the JasperReportTemplateFile entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<JasperReportTemplateFile> getJasperReportTemplateFileDataSet()
    {
        return new HibernateDataSet<JasperReportTemplateFile>(JasperReportTemplateFile.class, this, JasperReportTemplateFile.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoJasperReportTemplateFileDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a JasperReportTemplateFile object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(JasperReportTemplateFile transientInstance) {
        logger.debug("persisting JasperReportTemplateFile instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified JasperReportTemplateFile in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(JasperReportTemplateFile instance) {
        logger.debug("attaching dirty JasperReportTemplateFile instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified JasperReportTemplateFile instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(JasperReportTemplateFile instance) {
        logger.debug("attaching clean JasperReportTemplateFile instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a JasperReportTemplateFile instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(JasperReportTemplateFile persistentInstance) {
        logger.debug("deleting JasperReportTemplateFile instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a JasperReportTemplateFile instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public JasperReportTemplateFile merge(JasperReportTemplateFile detachedInstance) {
        logger.debug("merging JasperReportTemplateFile instance");
        JasperReportTemplateFile result = (JasperReportTemplateFile) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a JasperReportTemplateFile instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public JasperReportTemplateFile findById( java.lang.Long id) {
        logger.debug("getting JasperReportTemplateFile instance with id: " + id);
        JasperReportTemplateFile instance = (JasperReportTemplateFile) getSession()
                .get(JasperReportTemplateFile.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all JasperReportTemplateFile instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<JasperReportTemplateFile> findAll() {

 		List<JasperReportTemplateFile> instances = new ArrayList<JasperReportTemplateFile>();
		logger.debug("getting all JasperReportTemplateFile instances");
        instances = getSession().createCriteria(JasperReportTemplateFile.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<JasperReportTemplateFile>) instances;
    }


	/**
	 * Gets a {@link List} of all JasperReportTemplateFile instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<JasperReportTemplateFile> findByExample(JasperReportTemplateFile instance) {
        logger.debug("finding JasperReportTemplateFile instance by example");
        List<JasperReportTemplateFile> results = (List<JasperReportTemplateFile>) getSession()
                .createCriteria(JasperReportTemplateFile.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplateFile instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<JasperReportTemplateFile> findByFieldParcial(JasperReportTemplateFile.Fields field, String value) {
        logger.debug("finding JasperReportTemplateFile instance by parcial value: "+field+" like "+value);
        List<JasperReportTemplateFile> results = (List<JasperReportTemplateFile>) getSession()
                .createCriteria(JasperReportTemplateFile.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all JasperReportTemplateFile instances
	 * in the persistence layer than match the fileName attribute with the given value
	 *
	 * @param fileName to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplateFile> findByFileName(String fileName) {
        JasperReportTemplateFile instance = new JasperReportTemplateFile();

        instance.setFileName(fileName);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplateFile instances
	 * in the persistence layer than match the fileType attribute with the given value
	 *
	 * @param fileType to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplateFile> findByFileType(String fileType) {
        JasperReportTemplateFile instance = new JasperReportTemplateFile();

        instance.setFileType(fileType);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplateFile instances
	 * in the persistence layer than match the fileSize attribute with the given value
	 *
	 * @param fileSize to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplateFile> findByFileSize(Long fileSize) {
        JasperReportTemplateFile instance = new JasperReportTemplateFile();

        instance.setFileSize(fileSize);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplateFile instances
	 * in the persistence layer than match the documentId attribute with the given value
	 *
	 * @param documentId to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplateFile> findByDocumentId(Long documentId) {
        JasperReportTemplateFile instance = new JasperReportTemplateFile();

        instance.setDocumentId(documentId);

        return findByExample(instance);
    }

}

