package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.JasperReportTemplateParam;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoJasperReportTemplateParamDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class JasperReportTemplateParam.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.JasperReportTemplateParam
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoJasperReportTemplateParamDAOImpl implements IAutoJasperReportTemplateParamDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the JasperReportTemplateParam entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<JasperReportTemplateParam> getJasperReportTemplateParamDataSet()
    {
        return new HibernateDataSet<JasperReportTemplateParam>(JasperReportTemplateParam.class, this, JasperReportTemplateParam.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoJasperReportTemplateParamDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a JasperReportTemplateParam object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(JasperReportTemplateParam transientInstance) {
        logger.debug("persisting JasperReportTemplateParam instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified JasperReportTemplateParam in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(JasperReportTemplateParam instance) {
        logger.debug("attaching dirty JasperReportTemplateParam instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified JasperReportTemplateParam instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(JasperReportTemplateParam instance) {
        logger.debug("attaching clean JasperReportTemplateParam instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a JasperReportTemplateParam instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(JasperReportTemplateParam persistentInstance) {
        logger.debug("deleting JasperReportTemplateParam instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a JasperReportTemplateParam instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public JasperReportTemplateParam merge(JasperReportTemplateParam detachedInstance) {
        logger.debug("merging JasperReportTemplateParam instance");
        JasperReportTemplateParam result = (JasperReportTemplateParam) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a JasperReportTemplateParam instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public JasperReportTemplateParam findById( java.lang.Long id) {
        logger.debug("getting JasperReportTemplateParam instance with id: " + id);
        JasperReportTemplateParam instance = (JasperReportTemplateParam) getSession()
                .get(JasperReportTemplateParam.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all JasperReportTemplateParam instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<JasperReportTemplateParam> findAll() {

 		List<JasperReportTemplateParam> instances = new ArrayList<JasperReportTemplateParam>();
		logger.debug("getting all JasperReportTemplateParam instances");
        instances = getSession().createCriteria(JasperReportTemplateParam.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<JasperReportTemplateParam>) instances;
    }


	/**
	 * Gets a {@link List} of all JasperReportTemplateParam instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<JasperReportTemplateParam> findByExample(JasperReportTemplateParam instance) {
        logger.debug("finding JasperReportTemplateParam instance by example");
        List<JasperReportTemplateParam> results = (List<JasperReportTemplateParam>) getSession()
                .createCriteria(JasperReportTemplateParam.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplateParam instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<JasperReportTemplateParam> findByFieldParcial(JasperReportTemplateParam.Fields field, String value) {
        logger.debug("finding JasperReportTemplateParam instance by parcial value: "+field+" like "+value);
        List<JasperReportTemplateParam> results = (List<JasperReportTemplateParam>) getSession()
                .createCriteria(JasperReportTemplateParam.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all JasperReportTemplateParam instances
	 * in the persistence layer than match the parameterId attribute with the given value
	 *
	 * @param parameterId to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplateParam> findByParameterId(String parameterId) {
        JasperReportTemplateParam instance = new JasperReportTemplateParam();

        instance.setParameterId(parameterId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplateParam instances
	 * in the persistence layer than match the parameterName attribute with the given value
	 *
	 * @param parameterName to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplateParam> findByParameterName(String parameterName) {
        JasperReportTemplateParam instance = new JasperReportTemplateParam();

        instance.setParameterName(parameterName);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplateParam instances
	 * in the persistence layer than match the parameterOptionsType attribute with the given value
	 *
	 * @param parameterOptionsType to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplateParam> findByParameterOptionsType(Long parameterOptionsType) {
        JasperReportTemplateParam instance = new JasperReportTemplateParam();

        instance.setParameterOptionsType(parameterOptionsType);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplateParam instances
	 * in the persistence layer than match the parameterOptionsList attribute with the given value
	 *
	 * @param parameterOptionsList to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplateParam> findByParameterOptionsList(String parameterOptionsList) {
        JasperReportTemplateParam instance = new JasperReportTemplateParam();

        instance.setParameterOptionsList(parameterOptionsList);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplateParam instances
	 * in the persistence layer than match the parameterOptionsSql attribute with the given value
	 *
	 * @param parameterOptionsSql to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplateParam> findByParameterOptionsSql(String parameterOptionsSql) {
        JasperReportTemplateParam instance = new JasperReportTemplateParam();

        instance.setParameterOptionsSql(parameterOptionsSql);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplateParam instances
	 * in the persistence layer than match the isEnabled attribute with the given value
	 *
	 * @param isEnabled to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplateParam> findByIsEnabled(boolean isEnabled) {
        JasperReportTemplateParam instance = new JasperReportTemplateParam();

        instance.setIsEnabled(isEnabled);

        return findByExample(instance);
    }

}

