package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.SqlDataSource;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoSqlDataSourceDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class SqlDataSource.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.SqlDataSource
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoSqlDataSourceDAOImpl implements IAutoSqlDataSourceDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the SqlDataSource entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<SqlDataSource> getSqlDataSourceDataSet()
    {
        return new HibernateDataSet<SqlDataSource>(SqlDataSource.class, this, SqlDataSource.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoSqlDataSourceDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a SqlDataSource object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(SqlDataSource transientInstance) {
        logger.debug("persisting SqlDataSource instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified SqlDataSource in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(SqlDataSource instance) {
        logger.debug("attaching dirty SqlDataSource instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified SqlDataSource instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(SqlDataSource instance) {
        logger.debug("attaching clean SqlDataSource instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a SqlDataSource instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(SqlDataSource persistentInstance) {
        logger.debug("deleting SqlDataSource instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a SqlDataSource instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public SqlDataSource merge(SqlDataSource detachedInstance) {
        logger.debug("merging SqlDataSource instance");
        SqlDataSource result = (SqlDataSource) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a SqlDataSource instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public SqlDataSource findById( java.lang.Long id) {
        logger.debug("getting SqlDataSource instance with id: " + id);
        SqlDataSource instance = (SqlDataSource) getSession()
                .get(SqlDataSource.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all SqlDataSource instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<SqlDataSource> findAll() {

 		List<SqlDataSource> instances = new ArrayList<SqlDataSource>();
		logger.debug("getting all SqlDataSource instances");
        instances = getSession().createCriteria(SqlDataSource.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<SqlDataSource>) instances;
    }


	/**
	 * Gets a {@link List} of all SqlDataSource instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<SqlDataSource> findByExample(SqlDataSource instance) {
        logger.debug("finding SqlDataSource instance by example");
        List<SqlDataSource> results = (List<SqlDataSource>) getSession()
                .createCriteria(SqlDataSource.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all SqlDataSource instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<SqlDataSource> findByFieldParcial(SqlDataSource.Fields field, String value) {
        logger.debug("finding SqlDataSource instance by parcial value: "+field+" like "+value);
        List<SqlDataSource> results = (List<SqlDataSource>) getSession()
                .createCriteria(SqlDataSource.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all SqlDataSource instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<SqlDataSource> findByName(String name) {
        SqlDataSource instance = new SqlDataSource();

        instance.setName(name);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all SqlDataSource instances
	 * in the persistence layer than match the url attribute with the given value
	 *
	 * @param url to match
	 * @return the {@link List} of instances
	 */
    public List<SqlDataSource> findByUrl(String url) {
        SqlDataSource instance = new SqlDataSource();

        instance.setUrl(url);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all SqlDataSource instances
	 * in the persistence layer than match the userName attribute with the given value
	 *
	 * @param userName to match
	 * @return the {@link List} of instances
	 */
    public List<SqlDataSource> findByUserName(String userName) {
        SqlDataSource instance = new SqlDataSource();

        instance.setUserName(userName);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all SqlDataSource instances
	 * in the persistence layer than match the password attribute with the given value
	 *
	 * @param password to match
	 * @return the {@link List} of instances
	 */
    public List<SqlDataSource> findByPassword(String password) {
        SqlDataSource instance = new SqlDataSource();

        instance.setPassword(password);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all SqlDataSource instances
	 * in the persistence layer than match the dialect attribute with the given value
	 *
	 * @param dialect to match
	 * @return the {@link List} of instances
	 */
    public List<SqlDataSource> findByDialect(String dialect) {
        SqlDataSource instance = new SqlDataSource();

        instance.setDialect(dialect);

        return findByExample(instance);
    }

}

