package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.UserPreferences;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoUserPreferencesDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class UserPreferences.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.UserPreferences
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoUserPreferencesDAOImpl implements IAutoUserPreferencesDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the UserPreferences entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserPreferences> getUserPreferencesDataSet()
    {
        return new HibernateDataSet<UserPreferences>(UserPreferences.class, this, UserPreferences.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoUserPreferencesDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a UserPreferences object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(UserPreferences transientInstance) {
        logger.debug("persisting UserPreferences instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified UserPreferences in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(UserPreferences instance) {
        logger.debug("attaching dirty UserPreferences instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified UserPreferences instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(UserPreferences instance) {
        logger.debug("attaching clean UserPreferences instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a UserPreferences instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(UserPreferences persistentInstance) {
        logger.debug("deleting UserPreferences instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a UserPreferences instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public UserPreferences merge(UserPreferences detachedInstance) {
        logger.debug("merging UserPreferences instance");
        UserPreferences result = (UserPreferences) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a UserPreferences instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public UserPreferences findById( java.lang.Long id) {
        logger.debug("getting UserPreferences instance with id: " + id);
        UserPreferences instance = (UserPreferences) getSession()
                .get(UserPreferences.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<UserPreferences> findAll() {

 		List<UserPreferences> instances = new ArrayList<UserPreferences>();
		logger.debug("getting all UserPreferences instances");
        instances = getSession().createCriteria(UserPreferences.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<UserPreferences>) instances;
    }


	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<UserPreferences> findByExample(UserPreferences instance) {
        logger.debug("finding UserPreferences instance by example");
        List<UserPreferences> results = (List<UserPreferences>) getSession()
                .createCriteria(UserPreferences.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<UserPreferences> findByFieldParcial(UserPreferences.Fields field, String value) {
        logger.debug("finding UserPreferences instance by parcial value: "+field+" like "+value);
        List<UserPreferences> results = (List<UserPreferences>) getSession()
                .createCriteria(UserPreferences.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer than match the configId attribute with the given value
	 *
	 * @param configId to match
	 * @return the {@link List} of instances
	 */
    public List<UserPreferences> findByConfigId(String configId) {
        UserPreferences instance = new UserPreferences();

        instance.setConfigId(configId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer than match the userId attribute with the given value
	 *
	 * @param userId to match
	 * @return the {@link List} of instances
	 */
    public List<UserPreferences> findByUserId(String userId) {
        UserPreferences instance = new UserPreferences();

        instance.setUserId(userId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer than match the attributeKey attribute with the given value
	 *
	 * @param attributeKey to match
	 * @return the {@link List} of instances
	 */
    public List<UserPreferences> findByAttributeKey(String attributeKey) {
        UserPreferences instance = new UserPreferences();

        instance.setAttributeKey(attributeKey);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer than match the attributeValue attribute with the given value
	 *
	 * @param attributeValue to match
	 * @return the {@link List} of instances
	 */
    public List<UserPreferences> findByAttributeValue(String attributeValue) {
        UserPreferences instance = new UserPreferences();

        instance.setAttributeValue(attributeValue);

        return findByExample(instance);
    }

}

