package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.IDDMService;
import pt.digitalis.dif.dem.managers.impl.model.dao.IManagerDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.ManagerDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Manager;
import pt.digitalis.dif.dem.managers.impl.model.dao.IDashboardDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.DashboardDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Dashboard;
import pt.digitalis.dif.dem.managers.impl.model.dao.IAreaDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.AreaDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Area;
import pt.digitalis.dif.dem.managers.impl.model.dao.IIndicatorDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.IndicatorDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Indicator;
import pt.digitalis.dif.dem.managers.impl.model.dao.IDashboardIndicatorDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.DashboardIndicatorDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.DashboardIndicator;
import pt.digitalis.dif.dem.managers.impl.model.dao.IFilterDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.FilterDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Filter;
import pt.digitalis.dif.dem.managers.impl.model.dao.ISerieDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.SerieDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Serie;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class DDMServiceImpl implements IDDMService {

	/**
	 * Obtains a new Manager DAO
	 *
	 * @return A new IManagerDAO
	 */
    public IManagerDAO getManagerDAO() {
    	return new ManagerDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Manager entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Manager> getManagerDataSet() {
        return new HibernateDataSet<Manager>(Manager.class, new ManagerDAOImpl(),
                Manager.getPKFieldListAsString());
    }

	/**
	 * Obtains a new Dashboard DAO
	 *
	 * @return A new IDashboardDAO
	 */
    public IDashboardDAO getDashboardDAO() {
    	return new DashboardDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Dashboard entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Dashboard> getDashboardDataSet() {
        return new HibernateDataSet<Dashboard>(Dashboard.class, new DashboardDAOImpl(),
                Dashboard.getPKFieldListAsString());
    }

	/**
	 * Obtains a new Area DAO
	 *
	 * @return A new IAreaDAO
	 */
    public IAreaDAO getAreaDAO() {
    	return new AreaDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Area entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Area> getAreaDataSet() {
        return new HibernateDataSet<Area>(Area.class, new AreaDAOImpl(),
                Area.getPKFieldListAsString());
    }

	/**
	 * Obtains a new Indicator DAO
	 *
	 * @return A new IIndicatorDAO
	 */
    public IIndicatorDAO getIndicatorDAO() {
    	return new IndicatorDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Indicator entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Indicator> getIndicatorDataSet() {
        return new HibernateDataSet<Indicator>(Indicator.class, new IndicatorDAOImpl(),
                Indicator.getPKFieldListAsString());
    }

	/**
	 * Obtains a new DashboardIndicator DAO
	 *
	 * @return A new IDashboardIndicatorDAO
	 */
    public IDashboardIndicatorDAO getDashboardIndicatorDAO() {
    	return new DashboardIndicatorDAOImpl();
    }

    /**
     * Obtains a new DataSet for the DashboardIndicator entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DashboardIndicator> getDashboardIndicatorDataSet() {
        return new HibernateDataSet<DashboardIndicator>(DashboardIndicator.class, new DashboardIndicatorDAOImpl(),
                DashboardIndicator.getPKFieldListAsString());
    }

	/**
	 * Obtains a new Filter DAO
	 *
	 * @return A new IFilterDAO
	 */
    public IFilterDAO getFilterDAO() {
    	return new FilterDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Filter entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Filter> getFilterDataSet() {
        return new HibernateDataSet<Filter>(Filter.class, new FilterDAOImpl(),
                Filter.getPKFieldListAsString());
    }

	/**
	 * Obtains a new Serie DAO
	 *
	 * @return A new ISerieDAO
	 */
    public ISerieDAO getSerieDAO() {
    	return new SerieDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Serie entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Serie> getSerieDataSet() {
        return new HibernateDataSet<Serie>(Serie.class, new SerieDAOImpl(),
                Serie.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Manager.class)
            return getManagerDataSet();

        if (clazz == Dashboard.class)
            return getDashboardDataSet();

        if (clazz == Area.class)
            return getAreaDataSet();

        if (clazz == Indicator.class)
            return getIndicatorDataSet();

        if (clazz == DashboardIndicator.class)
            return getDashboardIndicatorDataSet();

        if (clazz == Filter.class)
            return getFilterDataSet();

        if (clazz == Serie.class)
            return getSerieDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Manager.class.getSimpleName()))
            return getManagerDataSet();

        if (entityName.equalsIgnoreCase(Dashboard.class.getSimpleName()))
            return getDashboardDataSet();

        if (entityName.equalsIgnoreCase(Area.class.getSimpleName()))
            return getAreaDataSet();

        if (entityName.equalsIgnoreCase(Indicator.class.getSimpleName()))
            return getIndicatorDataSet();

        if (entityName.equalsIgnoreCase(DashboardIndicator.class.getSimpleName()))
            return getDashboardIndicatorDataSet();

        if (entityName.equalsIgnoreCase(Filter.class.getSimpleName()))
            return getFilterDataSet();

        if (entityName.equalsIgnoreCase(Serie.class.getSimpleName()))
            return getSerieDataSet();

        return null;
    }
}