package pt.digitalis.dif.ioc;

import pt.digitalis.dif.configurations.ConfigurationsDatabaseImpl;
import pt.digitalis.dif.controller.interfaces.IModelManager;
import pt.digitalis.dif.controller.security.managers.IUserPreferencesManager;
import pt.digitalis.dif.dataminer.definition.IDashboardPersistence;
import pt.digitalis.dif.ddm.DashboardPersistenceBDImpl;
import pt.digitalis.dif.dem.managers.ICustomFormManager;
import pt.digitalis.dif.dem.managers.ITemplateManager;
import pt.digitalis.dif.dem.managers.impl.CustomFormManagerDBImpl;
import pt.digitalis.dif.dem.managers.impl.DIFRepositoryDBModelManager;
import pt.digitalis.dif.dem.managers.impl.TemplateManagerDBImpl;
import pt.digitalis.dif.model.hibernate.IAuditingLogger;
import pt.digitalis.dif.users.preferences.UserPreferencesManagerDBImpl;
import pt.digitalis.dif.utils.logging.AuditingLoggerDBImplementation;
import pt.digitalis.dif.utils.logging.ErrorLogManagerDBImpl;
import pt.digitalis.dif.utils.logging.IErrorLogManager;
import pt.digitalis.dif.utils.logging.performance.IPerformanceLogger;
import pt.digitalis.dif.utils.logging.performance.PerformanceLoggerDBImplementation;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Jan 3, 2014
 */
public class DIFRepositoryModule implements IIoCModule {

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {
        binder.bind(IModelManager.class, DIFRepositoryDBModelManager.class).withId(DIFRepositoryDBModelManager.MODEL_ID)
                .asSingleton();

        // Form customization
        binder.bind(ICustomFormManager.class, CustomFormManagerDBImpl.class).asSingleton().override();

        // Utilities
        binder.bind(IErrorLogManager.class, ErrorLogManagerDBImpl.class).asSingleton().override();
        binder.bind(ITemplateManager.class, TemplateManagerDBImpl.class).asSingleton().override();
        binder.bind(IDashboardPersistence.class, DashboardPersistenceBDImpl.class).asSingleton();
        binder.bind(IPerformanceLogger.class, PerformanceLoggerDBImplementation.class).asSingleton().override();
        binder.bind(IAuditingLogger.class, AuditingLoggerDBImplementation.class).override();

        // User preferences
        binder.bind(IUserPreferencesManager.class, UserPreferencesManagerDBImpl.class).asSingleton();

        // Configurations in DB
        binder.bind(IConfigurations.class, ConfigurationsDatabaseImpl.class).withId("Database").asSingleton().override();
    }
}
