package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.sql.Timestamp;
import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.AccessLog;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class AccessLog.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.AccessLog
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoAccessLogDAO extends IHibernateDAO<AccessLog> {

    /**
     * Obtains a new DataSet for the AccessLog entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<AccessLog> getAccessLogDataSet();

	/**
	 * Persist a AccessLog object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(AccessLog transientInstance);

	/**
	 * Updates a modified AccessLog in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(AccessLog instance);

	/**
	 * Attach an unmodified AccessLog instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(AccessLog instance);

	/**
	 * Removes a AccessLog instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(AccessLog persistentInstance);

	/**
	 * Merge a AccessLog instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public AccessLog merge(AccessLog detachedInstance);

	/**
	 * Finds a AccessLog instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public AccessLog findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findAll();


	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByFieldParcial(AccessLog.Fields field, String value);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the applicationId attribute with the given value
	 *
	 * @param applicationId to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByApplicationId(String applicationId);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the serviceId attribute with the given value
	 *
	 * @param serviceId to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByServiceId(String serviceId);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the stageId attribute with the given value
	 *
	 * @param stageId to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByStageId(String stageId);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the eventId attribute with the given value
	 *
	 * @param eventId to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByEventId(String eventId);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the requestType attribute with the given value
	 *
	 * @param requestType to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByRequestType(Character requestType);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the userId attribute with the given value
	 *
	 * @param userId to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByUserId(String userId);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the accessDate attribute with the given value
	 *
	 * @param accessDate to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByAccessDate(Timestamp accessDate);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the executionTime attribute with the given value
	 *
	 * @param executionTime to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByExecutionTime(Long executionTime);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the clientIp attribute with the given value
	 *
	 * @param clientIp to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByClientIp(String clientIp);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the requestDump attribute with the given value
	 *
	 * @param requestDump to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByRequestDump(String requestDump);

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the errorReport attribute with the given value
	 *
	 * @param errorReport to match
	 * @return the {@link List} of instances
	 */
    public List<AccessLog> findByErrorReport(String errorReport);
}
