package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstance;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class ReportInstance.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportInstance
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoReportInstanceDAO extends IHibernateDAO<ReportInstance> {

    /**
     * Obtains a new DataSet for the ReportInstance entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportInstance> getReportInstanceDataSet();

	/**
	 * Persist a ReportInstance object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportInstance transientInstance);

	/**
	 * Updates a modified ReportInstance in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportInstance instance);

	/**
	 * Attach an unmodified ReportInstance instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportInstance instance);

	/**
	 * Removes a ReportInstance instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportInstance persistentInstance);

	/**
	 * Merge a ReportInstance instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportInstance merge(ReportInstance detachedInstance);

	/**
	 * Finds a ReportInstance instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportInstance findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<ReportInstance> findAll();


	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstance> findByFieldParcial(ReportInstance.Fields field, String value);

	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstance> findByTitle(String title);

	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer than match the readonly attribute with the given value
	 *
	 * @param readonly to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstance> findByReadonly(boolean readonly);

	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer than match the businessKey attribute with the given value
	 *
	 * @param businessKey to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstance> findByBusinessKey(String businessKey);

	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer than match the documentId attribute with the given value
	 *
	 * @param documentId to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstance> findByDocumentId(Long documentId);
}
