package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigNode;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoConfigNodeDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ConfigNode.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ConfigNode
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoConfigNodeDAOImpl implements IAutoConfigNodeDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ConfigNode entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ConfigNode> getConfigNodeDataSet()
    {
        return new HibernateDataSet<ConfigNode>(ConfigNode.class, this, ConfigNode.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoConfigNodeDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ConfigNode object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ConfigNode transientInstance) {
        logger.debug("persisting ConfigNode instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ConfigNode in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ConfigNode instance) {
        logger.debug("attaching dirty ConfigNode instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ConfigNode instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ConfigNode instance) {
        logger.debug("attaching clean ConfigNode instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ConfigNode instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ConfigNode persistentInstance) {
        logger.debug("deleting ConfigNode instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ConfigNode instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ConfigNode merge(ConfigNode detachedInstance) {
        logger.debug("merging ConfigNode instance");
        ConfigNode result = (ConfigNode) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ConfigNode instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ConfigNode findById( java.lang.Long id) {
        logger.debug("getting ConfigNode instance with id: " + id);
        ConfigNode instance = (ConfigNode) getSession()
                .get(ConfigNode.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ConfigNode instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ConfigNode> findAll() {

 		List<ConfigNode> instances = new ArrayList<ConfigNode>();
		logger.debug("getting all ConfigNode instances");
        instances = getSession().createCriteria(ConfigNode.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ConfigNode>) instances;
    }


	/**
	 * Gets a {@link List} of all ConfigNode instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ConfigNode> findByExample(ConfigNode instance) {
        logger.debug("finding ConfigNode instance by example");
        List<ConfigNode> results = (List<ConfigNode>) getSession()
                .createCriteria(ConfigNode.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ConfigNode instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ConfigNode> findByFieldParcial(ConfigNode.Fields field, String value) {
        logger.debug("finding ConfigNode instance by parcial value: "+field+" like "+value);
        List<ConfigNode> results = (List<ConfigNode>) getSession()
                .createCriteria(ConfigNode.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all ConfigNode instances
	 * in the persistence layer than match the nodePath attribute with the given value
	 *
	 * @param nodePath to match
	 * @return the {@link List} of instances
	 */
    public List<ConfigNode> findByNodePath(String nodePath) {
        ConfigNode instance = new ConfigNode();

        instance.setNodePath(nodePath);

        return findByExample(instance);
    }

}

