package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.JasperReportTemplate;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoJasperReportTemplateDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class JasperReportTemplate.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.JasperReportTemplate
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoJasperReportTemplateDAOImpl implements IAutoJasperReportTemplateDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the JasperReportTemplate entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<JasperReportTemplate> getJasperReportTemplateDataSet()
    {
        return new HibernateDataSet<JasperReportTemplate>(JasperReportTemplate.class, this, JasperReportTemplate.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoJasperReportTemplateDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a JasperReportTemplate object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(JasperReportTemplate transientInstance) {
        logger.debug("persisting JasperReportTemplate instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified JasperReportTemplate in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(JasperReportTemplate instance) {
        logger.debug("attaching dirty JasperReportTemplate instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified JasperReportTemplate instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(JasperReportTemplate instance) {
        logger.debug("attaching clean JasperReportTemplate instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a JasperReportTemplate instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(JasperReportTemplate persistentInstance) {
        logger.debug("deleting JasperReportTemplate instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a JasperReportTemplate instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public JasperReportTemplate merge(JasperReportTemplate detachedInstance) {
        logger.debug("merging JasperReportTemplate instance");
        JasperReportTemplate result = (JasperReportTemplate) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a JasperReportTemplate instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public JasperReportTemplate findById( java.lang.Long id) {
        logger.debug("getting JasperReportTemplate instance with id: " + id);
        JasperReportTemplate instance = (JasperReportTemplate) getSession()
                .get(JasperReportTemplate.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<JasperReportTemplate> findAll() {

 		List<JasperReportTemplate> instances = new ArrayList<JasperReportTemplate>();
		logger.debug("getting all JasperReportTemplate instances");
        instances = getSession().createCriteria(JasperReportTemplate.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<JasperReportTemplate>) instances;
    }


	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<JasperReportTemplate> findByExample(JasperReportTemplate instance) {
        logger.debug("finding JasperReportTemplate instance by example");
        List<JasperReportTemplate> results = (List<JasperReportTemplate>) getSession()
                .createCriteria(JasperReportTemplate.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<JasperReportTemplate> findByFieldParcial(JasperReportTemplate.Fields field, String value) {
        logger.debug("finding JasperReportTemplate instance by parcial value: "+field+" like "+value);
        List<JasperReportTemplate> results = (List<JasperReportTemplate>) getSession()
                .createCriteria(JasperReportTemplate.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer than match the configId attribute with the given value
	 *
	 * @param configId to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplate> findByConfigId(String configId) {
        JasperReportTemplate instance = new JasperReportTemplate();

        instance.setConfigId(configId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer than match the businessId attribute with the given value
	 *
	 * @param businessId to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplate> findByBusinessId(String businessId) {
        JasperReportTemplate instance = new JasperReportTemplate();

        instance.setBusinessId(businessId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplate> findByTitle(String title) {
        JasperReportTemplate instance = new JasperReportTemplate();

        instance.setTitle(title);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplate> findByDescription(String description) {
        JasperReportTemplate instance = new JasperReportTemplate();

        instance.setDescription(description);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer than match the type attribute with the given value
	 *
	 * @param type to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplate> findByType(Long type) {
        JasperReportTemplate instance = new JasperReportTemplate();

        instance.setType(type);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer than match the templatePath attribute with the given value
	 *
	 * @param templatePath to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplate> findByTemplatePath(String templatePath) {
        JasperReportTemplate instance = new JasperReportTemplate();

        instance.setTemplatePath(templatePath);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer than match the isEnabled attribute with the given value
	 *
	 * @param isEnabled to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplate> findByIsEnabled(boolean isEnabled) {
        JasperReportTemplate instance = new JasperReportTemplate();

        instance.setIsEnabled(isEnabled);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer than match the logExecution attribute with the given value
	 *
	 * @param logExecution to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplate> findByLogExecution(boolean logExecution) {
        JasperReportTemplate instance = new JasperReportTemplate();

        instance.setLogExecution(logExecution);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportTemplate instances
	 * in the persistence layer than match the logFileResult attribute with the given value
	 *
	 * @param logFileResult to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportTemplate> findByLogFileResult(boolean logFileResult) {
        JasperReportTemplate instance = new JasperReportTemplate();

        instance.setLogFileResult(logFileResult);

        return findByExample(instance);
    }

}

