-----------------------------------------------------------------------------------------------------------------------
--- CONFIG_SET table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.CONFIG_SET
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  NAME                   VARCHAR(500) NOT NULL COMMENT 'The set name',
  DESCRIPTION            LONGTEXT NOT NULL     COMMENT 'The set description',
  PRIMARY KEY (`ID`), 
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$


-----------------------------------------------------------------------------------------------------------------------
--- CONFIG_SERVER_SET table
-----------------------------------------------------------------------------------------------------------------------

CREATE TABLE IF NOT EXISTS DIF.CONFIG_SERVER_SET
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  SERVER_UID             VARCHAR(500) NOT NULL COMMENT 'The server unique ID',
  CONFIG_SET_ID          INT NOT NULL 'The set ID', 
  PRIMARY KEY (`ID`), 
  CONSTRAINT `FK_CONFIG_SERVER_SET_SET` FOREIGN KEY (`CONFIG_SET_ID`) REFERENCES `CONFIG_SET` (`ID`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$


-----------------------------------------------------------------------------------------------------------------------
--- CONFIG_NODE table
-----------------------------------------------------------------------------------------------------------------------

CREATE TABLE IF NOT EXISTS DIF.CONFIG_NODE
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  CONFIG_SET_ID          INT NOT NULL 'The Set ID (each application can have a diferent set of configurations, or share configuration sets)', 
  NODE_PATH              VARCHAR(800) NOT NULL COMMENT 'The node path',
  PRIMARY KEY (`ID`), 
  CONSTRAINT `FK_CONFIG_NODE_SET` FOREIGN KEY (`CONFIG_SET_ID`) REFERENCES `CONFIG_SET` (`ID`)
  INDEX `CONFIG_SET_NODE_IDX` (`CONFIG_SET_ID`,`NODE_PATH`),
  INDEX `CONFIG_NODE_SET_IDX` (`NODE_PATH`,`CONFIG_SET_ID`),
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-----------------------------------------------------------------------------------------------------------------------
--- CONFIGURATION table
-----------------------------------------------------------------------------------------------------------------------

CREATE TABLE IF NOT EXISTS DIF.CONFIGURATION
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  CONFIG_NODE_ID         INT NOT NULL                COMMENT 'Configuration node ID', 
  KEY                    VARCHAR(500) NOT NULL       COMMENT 'The configuration property key identifier',
  VALUE                  VARCHAR(4000) NOT NULL      COMMENT 'The configuration property value',
  VALUE_X_L              LARGETEXT NOT NULL          COMMENT 'The configuration property value if larger than 4000 in size',
  PRIMARY KEY (`ID`), 
  CONSTRAINT `FK_CONFIG_CONFIG_NODE` FOREIGN KEY (`CONFIG_NODE_ID`) REFERENCES `CONFIG_NODE` (`ID`) ON DELETE CASCADE
  INDEX `CONFIG_NODE_KEY_IDX` (`CONFIG_NODE_ID`,`KEY`),
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$
