-----------------------------------------------------------------------------------------------------------------------
--- CONFIG_SET table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'CONFIG_SET';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.CONFIG_SET( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  NAME                   VARCHAR(500) NOT NULL, '||
      '  DESCRIPTION            VARCHAR(4000) '||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.CONFIG_SET.ID IS 'ID';
COMMENT ON COLUMN dif.CONFIG_SET.NAME IS 'The set name';
COMMENT ON COLUMN dif.CONFIG_SET.DESCRIPTION IS 'The set description';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'CONFIG_SET'
  AND    CONSTRAINT_NAME = 'CONFIG_SET_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONFIG_SET ADD CONSTRAINT CONFIG_SET_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_CONFIG_SET';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_CONFIG_SET MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/


-----------------------------------------------------------------------------------------------------------------------
--- CONFIG_SERVER_SET table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'CONFIG_SERVER_SET';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.CONFIG_SERVER_SET( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  SERVER_UID             VARCHAR(500) NOT NULL, '||
      '  CONFIG_SET_ID          NUMBER(10) NOT NULL '||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.CONFIG_SERVER_SET.ID IS 'ID';
COMMENT ON COLUMN dif.CONFIG_SERVER_SET.SERVER_UID IS 'The server unique ID';
COMMENT ON COLUMN dif.CONFIG_SERVER_SET.CONFIG_SET_ID IS 'The set ID';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'CONFIG_SERVER_SET'
  AND    CONSTRAINT_NAME = 'CONFIG_SERVER_SET_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONFIG_SERVER_SET ADD CONSTRAINT CONFIG_SERVER_SET_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_CONFIG_SERVER_SET';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_CONFIG_SERVER_SET MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'CONFIG_SERVER_SET'
  AND    CONSTRAINT_NAME = 'FK_CONFIG_SERVER_SET_SET';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONFIG_SERVER_SET ADD CONSTRAINT FK_CONFIG_SERVER_SET_SET FOREIGN KEY (CONFIG_SET_ID) REFERENCES DIF.CONFIG_SET (ID)';
  END IF;
END;
/


-----------------------------------------------------------------------------------------------------------------------
--- CONFIG_NODE table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'CONFIG_NODE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.CONFIG_NODE( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  CONFIG_SET_ID          NUMBER(10) NOT NULL, '||
      '  NODE_PATH              VARCHAR(800) NOT NULL '||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.CONFIG_NODE.ID IS 'ID';
COMMENT ON COLUMN dif.CONFIG_NODE.CONFIG_SET_ID IS 'The Set ID (each application can have a diferent set of configurations, or share configuration sets)';
COMMENT ON COLUMN dif.CONFIG_NODE.NODE_PATH IS 'The node path';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'CONFIG_NODE'
  AND    CONSTRAINT_NAME = 'CONFIG_NODE_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONFIG_NODE ADD CONSTRAINT CONFIG_NODE_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_CONFIG_NODE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_CONFIG_NODE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'CONFIG_NODE'
  AND    CONSTRAINT_NAME = 'FK_CONFIG_NODE_SET';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONFIG_NODE ADD CONSTRAINT FK_CONFIG_NODE_SET FOREIGN KEY (CONFIG_SET_ID) REFERENCES DIF.CONFIG_SET (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'CONFIG_NODE'
  AND    INDEX_NAME = 'CONFIG_SET_NODE_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.CONFIG_SET_NODE_IDX '||
                      'ON DIF.CONFIG_NODE (CONFIG_SET_ID,NODE_PATH) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'CONFIG_NODE'
  AND    INDEX_NAME = 'CONFIG_NODE_SET_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.CONFIG_NODE_SET_IDX '||
                      'ON DIF.CONFIG_NODE (NODE_PATH,CONFIG_SET_ID) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

-----------------------------------------------------------------------------------------------------------------------
--- CONFIGURATION table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'CONFIGURATION';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.CONFIGURATION( '||
      '  ID                  NUMBER(10) NOT NULL, '||
      '  CONFIG_NODE_ID      NUMBER(10) NOT NULL, '||
      '  KEY                 VARCHAR2(500) NOT NULL, '||
      '  VALUE               VARCHAR2(4000), '||
      '  VALUE_X_L           CLOB'||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.CONFIGURATION.ID IS 'ID';
COMMENT ON COLUMN dif.CONFIGURATION.CONFIG_NODE_ID IS 'Configuration node ID';
COMMENT ON COLUMN dif.CONFIGURATION.KEY IS 'The configuration property key identifier';
COMMENT ON COLUMN dif.CONFIGURATION.VALUE IS 'The configuration property value';
COMMENT ON COLUMN dif.CONFIGURATION.VALUE_X_L IS 'The configuration property value if larger than 4000 in size';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'CONFIGURATION'
  AND    CONSTRAINT_NAME = 'CONFIGURATION_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONFIGURATION ADD CONSTRAINT CONFIGURATION_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_CONFIGURATION';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_CONFIGURATION MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'CONFIGURATION'
  AND    CONSTRAINT_NAME = 'FK_CONFIG_CONFIG_NODE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONFIGURATION ADD CONSTRAINT FK_CONFIG_CONFIG_NODE FOREIGN KEY (CONFIG_NODE_ID) REFERENCES DIF.CONFIG_NODE (ID) ON DELETE CASCADE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'CONFIGURATION'
  AND    INDEX_NAME = 'CONFIG_NODE_KEY_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.CONFIG_NODE_KEY_IDX '||
                      'ON DIF.CONFIGURATION (CONFIG_NODE_ID,KEY) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/
