/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoDataConsentReviewDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentReview;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoDataConsentReviewDAOImpl
implements IAutoDataConsentReviewDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<DataConsentReview> getDataConsentReviewDataSet() {
        return new HibernateDataSet(DataConsentReview.class, (IHibernateDAO)this, DataConsentReview.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(DataConsentReview transientInstance) {
        this.logger.debug((Object)"persisting DataConsentReview instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(DataConsentReview instance) {
        this.logger.debug((Object)"attaching dirty DataConsentReview instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(DataConsentReview instance) {
        this.logger.debug((Object)"attaching clean DataConsentReview instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(DataConsentReview persistentInstance) {
        this.logger.debug((Object)"deleting DataConsentReview instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public DataConsentReview merge(DataConsentReview detachedInstance) {
        this.logger.debug((Object)"merging DataConsentReview instance");
        DataConsentReview result = (DataConsentReview)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public DataConsentReview findById(Long id) {
        this.logger.debug((Object)("getting DataConsentReview instance with id: " + id));
        DataConsentReview instance = (DataConsentReview)this.getSession().get(DataConsentReview.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<DataConsentReview> findAll() {
        List<DataConsentReview> instances = new ArrayList();
        this.logger.debug((Object)"getting all DataConsentReview instances");
        instances = this.getSession().createCriteria(DataConsentReview.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<DataConsentReview> findByExample(DataConsentReview instance) {
        this.logger.debug((Object)"finding DataConsentReview instance by example");
        List results = this.getSession().createCriteria(DataConsentReview.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<DataConsentReview> findByFieldParcial(DataConsentReview.Fields field, String value) {
        this.logger.debug((Object)("finding DataConsentReview instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(DataConsentReview.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<DataConsentReview> findByUserId(String userId) {
        DataConsentReview instance = new DataConsentReview();
        instance.setUserId(userId);
        return this.findByExample(instance);
    }

    @Override
    public List<DataConsentReview> findByLastReviewDate(Timestamp lastReviewDate) {
        DataConsentReview instance = new DataConsentReview();
        instance.setLastReviewDate(lastReviewDate);
        return this.findByExample(instance);
    }
}

