/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoIndicatorDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Indicator;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoIndicatorDAOImpl
implements IAutoIndicatorDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Indicator> getIndicatorDataSet() {
        return new HibernateDataSet(Indicator.class, (IHibernateDAO)this, Indicator.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(Indicator transientInstance) {
        this.logger.debug((Object)"persisting Indicator instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Indicator instance) {
        this.logger.debug((Object)"attaching dirty Indicator instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Indicator instance) {
        this.logger.debug((Object)"attaching clean Indicator instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Indicator persistentInstance) {
        this.logger.debug((Object)"deleting Indicator instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Indicator merge(Indicator detachedInstance) {
        this.logger.debug((Object)"merging Indicator instance");
        Indicator result = (Indicator)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Indicator findById(Long id) {
        this.logger.debug((Object)("getting Indicator instance with id: " + id));
        Indicator instance = (Indicator)this.getSession().get(Indicator.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Indicator> findAll() {
        List<Indicator> instances = new ArrayList();
        this.logger.debug((Object)"getting all Indicator instances");
        instances = this.getSession().createCriteria(Indicator.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Indicator> findByExample(Indicator instance) {
        this.logger.debug((Object)"finding Indicator instance by example");
        List results = this.getSession().createCriteria(Indicator.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Indicator> findByFieldParcial(Indicator.Fields field, String value) {
        this.logger.debug((Object)("finding Indicator instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Indicator.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Indicator> findByUniqueId(String uniqueId) {
        Indicator instance = new Indicator();
        instance.setUniqueId(uniqueId);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByDefinitionType(Character definitionType) {
        Indicator instance = new Indicator();
        instance.setDefinitionType(definitionType);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByTitle(String title) {
        Indicator instance = new Indicator();
        instance.setTitle(title);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByDescription(String description) {
        Indicator instance = new Indicator();
        instance.setDescription(description);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByDescriptionTitle(String descriptionTitle) {
        Indicator instance = new Indicator();
        instance.setDescriptionTitle(descriptionTitle);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByGroupTitle(String groupTitle) {
        Indicator instance = new Indicator();
        instance.setGroupTitle(groupTitle);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByAutoRefreshInt(Long autoRefreshInt) {
        Indicator instance = new Indicator();
        instance.setAutoRefreshInt(autoRefreshInt);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByLimitTopRecords(Long limitTopRecords) {
        Indicator instance = new Indicator();
        instance.setLimitTopRecords(limitTopRecords);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByMaxValue(Long maxValue) {
        Indicator instance = new Indicator();
        instance.setMaxValue(maxValue);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByUnitSuffix(String unitSuffix) {
        Indicator instance = new Indicator();
        instance.setUnitSuffix(unitSuffix);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByAxisXTitle(String axisXTitle) {
        Indicator instance = new Indicator();
        instance.setAxisXTitle(axisXTitle);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByAxisYTitle(String axisYTitle) {
        Indicator instance = new Indicator();
        instance.setAxisYTitle(axisYTitle);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByTotalField(boolean totalField) {
        Indicator instance = new Indicator();
        instance.setTotalField(totalField);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByHideMarkers(boolean hideMarkers) {
        Indicator instance = new Indicator();
        instance.setHideMarkers(hideMarkers);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByLegend(boolean legend) {
        Indicator instance = new Indicator();
        instance.setLegend(legend);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByTimeKeys(boolean timeKeys) {
        Indicator instance = new Indicator();
        instance.setTimeKeys(timeKeys);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByUseMinutes(boolean useMinutes) {
        Indicator instance = new Indicator();
        instance.setUseMinutes(useMinutes);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByQuerySql(String querySql) {
        Indicator instance = new Indicator();
        instance.setQuerySql(querySql);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByViewsToRefresh(String viewsToRefresh) {
        Indicator instance = new Indicator();
        instance.setViewsToRefresh(viewsToRefresh);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByRestrictGroups(String restrictGroups) {
        Indicator instance = new Indicator();
        instance.setRestrictGroups(restrictGroups);
        return this.findByExample(instance);
    }

    @Override
    public List<Indicator> findByRestrictProfiles(String restrictProfiles) {
        Indicator instance = new Indicator();
        instance.setRestrictProfiles(restrictProfiles);
        return this.findByExample(instance);
    }
}

