/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoTemplateRepositoryDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.TemplateRepository;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoTemplateRepositoryDAOImpl
implements IAutoTemplateRepositoryDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<TemplateRepository> getTemplateRepositoryDataSet() {
        return new HibernateDataSet(TemplateRepository.class, (IHibernateDAO)this, TemplateRepository.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(TemplateRepository transientInstance) {
        this.logger.debug((Object)"persisting TemplateRepository instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(TemplateRepository instance) {
        this.logger.debug((Object)"attaching dirty TemplateRepository instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(TemplateRepository instance) {
        this.logger.debug((Object)"attaching clean TemplateRepository instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(TemplateRepository persistentInstance) {
        this.logger.debug((Object)"deleting TemplateRepository instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public TemplateRepository merge(TemplateRepository detachedInstance) {
        this.logger.debug((Object)"merging TemplateRepository instance");
        TemplateRepository result = (TemplateRepository)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public TemplateRepository findById(Long id) {
        this.logger.debug((Object)("getting TemplateRepository instance with id: " + id));
        TemplateRepository instance = (TemplateRepository)this.getSession().get(TemplateRepository.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<TemplateRepository> findAll() {
        List<TemplateRepository> instances = new ArrayList();
        this.logger.debug((Object)"getting all TemplateRepository instances");
        instances = this.getSession().createCriteria(TemplateRepository.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<TemplateRepository> findByExample(TemplateRepository instance) {
        this.logger.debug((Object)"finding TemplateRepository instance by example");
        List results = this.getSession().createCriteria(TemplateRepository.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<TemplateRepository> findByFieldParcial(TemplateRepository.Fields field, String value) {
        this.logger.debug((Object)("finding TemplateRepository instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(TemplateRepository.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<TemplateRepository> findByName(String name) {
        TemplateRepository instance = new TemplateRepository();
        instance.setName(name);
        return this.findByExample(instance);
    }

    @Override
    public List<TemplateRepository> findByLanguage(String language) {
        TemplateRepository instance = new TemplateRepository();
        instance.setLanguage(language);
        return this.findByExample(instance);
    }

    @Override
    public List<TemplateRepository> findByContent(String content) {
        TemplateRepository instance = new TemplateRepository();
        instance.setContent(content);
        return this.findByExample(instance);
    }
}

