-- MANAGER Table
-------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.`MANAGER` (
  `ID` MEDIUMINT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column',
  `UNIQUE_ID` VARCHAR(200) COLLATE UTF8_BIN NOT NULL COMMENT 'Business unique ID',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `MANAGER_UNIQUE_ID_UK` (`UNIQUE_ID`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-------------------------------------------------------------
-- AREA Table
-------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.`AREA` (
  `ID` MEDIUMINT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column',
  `UNIQUE_ID` VARCHAR(200) COLLATE UTF8_BIN NOT NULL COMMENT 'Business unique ID',
  `TITLE` VARCHAR(500) COLLATE UTF8_BIN NOT NULL COMMENT 'The area title',
  `DATABASE_URL` VARCHAR(2000) COLLATE UTF8_BIN COMMENT 'BD URL to get data from',
  `DATABASE_USER` VARCHAR(500) COLLATE UTF8_BIN COMMENT 'BD username to connect',
  `DATABASE_PASS` VARCHAR(100) COLLATE UTF8_BIN COMMENT 'BD password to connect',
  `RESTRICT_GROUPS` VARCHAR(4000) COLLATE UTF8_BIN COMMENT 'List of default groups to restrict access to all area indicators',
  `RESTRICT_PROFILES` VARCHAR(4000) COLLATE UTF8_BIN COMMENT 'List of default profiles to restrict access to all area indicators',
  `MANAGER_ID` MEDIUMINT(10) NOT NULL COMMENT 'The parent manager ID',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `AREA_UNIQUE_ID_UK` (`UNIQUE_ID`),
  KEY `FK_AREA_MANAGER_IDX` (`MANAGER_ID`),
  CONSTRAINT `FK_AREA_MANAGER` FOREIGN KEY (`MANAGER_ID`) REFERENCES `MANAGER` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-------------------------------------------------------------
-- INDICATOR Table
-------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.`INDICATOR` (
  `ID` MEDIUMINT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column',
  `UNIQUE_ID` VARCHAR(200) COLLATE UTF8_BIN NOT NULL COMMENT 'Business unique ID',
  `DEFINITION_TYPE` ENUM('C','D') NOT NULL COMMENT 'The indicator type of definition',
  `AREA_ID` MEDIUMINT(10) NOT NULL COMMENT 'The parent area ID',
  `TITLE` VARCHAR(500) COLLATE UTF8_BIN NOT NULL COMMENT 'The indicator title',
  `DESCRIPTION` VARCHAR(4000) COLLATE UTF8_BIN COMMENT 'The indicator description',
  `DESCRIPTION_TITLE` VARCHAR(500) COLLATE UTF8_BIN COMMENT 'The indicator title description',
  `GROUP_TITLE` VARCHAR(2000) COLLATE UTF8_BIN COMMENT 'The group title',
  `AUTO_REFRESH_INT` MEDIUMINT(10) COMMENT 'If auto-refresh is present (in ms)',
  `LIMIT_TOP_RECORDS` MEDIUMINT(3) COMMENT 'Limit the first records',
  `MAX_VALUE` MEDIUMINT(20) COMMENT 'The scale max value if rigid',
  `UNIT_SUFFIX` VARCHAR(100) COLLATE UTF8_BIN COMMENT 'The unix suffix',
  `AXIS_X_TITLE` VARCHAR(200) COLLATE UTF8_BIN COMMENT 'The title of the X axis',
  `AXIS_Y_TITLE` VARCHAR(200) COLLATE UTF8_BIN COMMENT 'The title of the y axis',
  `TOTAL_FIELD` TINYINT(1) NOT NULL DEFAULT 0 COMMENT 'The total field if exists',
  `HIDE_MARKERS` TINYINT(1) NOT NULL DEFAULT 0 COMMENT 'Hide markers in line charts',
  `LEGEND` TINYINT(1) NOT NULL DEFAULT 0 COMMENT 'Show legend',
  `TIME_KEYS` TINYINT(1) NOT NULL DEFAULT 0 COMMENT 'Time key values',
  `USE_MINUTES` TINYINT(1) NOT NULL DEFAULT 0 COMMENT 'Show minutes',
  `QUERY_SQL` LONGTEXT NOT NULL COMMENT 'The SQL to gt the data from',
  `VIEWS_TO_REFRESH` VARCHAR(4000) COLLATE UTF8_BIN COMMENT 'The database view to refresh data for materialized or persistent pre calculated data sets',
  `RESTRICT_GROUPS` VARCHAR(4000) COLLATE UTF8_BIN COMMENT 'List of groups to restrict access to the indicators',
  `RESTRICT_PROFILES` VARCHAR(4000) COLLATE UTF8_BIN COMMENT 'List of profiles to restrict access to the indicators',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `AREA_UNIQUE_ID_UK` (`UNIQUE_ID`),
  KEY `FK_INDICATOR_AREA_IDX` (`AREA_ID`),
  CONSTRAINT `FK_INDICATOR_AREA` FOREIGN KEY (`AREA_ID`) REFERENCES `AREA` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-------------------------------------------------------------
-- DASHBOARD Table
-------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.`DASHBOARD` (
  `ID` MEDIUMINT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column',
  `UNIQUE_ID` VARCHAR(200) COLLATE UTF8_BIN NOT NULL COMMENT 'Business unique ID',
  `TITLE` VARCHAR(500) COLLATE UTF8_BIN NOT NULL COMMENT 'The dashboard title',
  `TEMPLATE` VARCHAR(2000) COLLATE UTF8_BIN NOT NULL COMMENT 'The layout of the indocators contained in the dashboard',
  `AREA_ID` MEDIUMINT(10) NOT NULL COMMENT 'The parent area ID',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `DASHBOARD_UNIQUE_ID_UK` (`UNIQUE_ID`),
  KEY `FK_DASHBOARD_AREA_IDX` (`AREA_ID`),
  CONSTRAINT `FK_DASHBOARD_AREA` FOREIGN KEY (`AREA_ID`) REFERENCES `AREA` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-------------------------------------------------------------
-- DASHBOARD_INDICATOR Table
-------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.`DASHBOARD_INDICATOR` (
  `ID` MEDIUMINT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column',
  `DASHBOARD_ID` MEDIUMINT(10) NOT NULL COMMENT 'The dashboard ID',
  `INDICATOR_ID` MEDIUMINT(10) NOT NULL COMMENT 'The indicator ID',
  PRIMARY KEY (`ID`),
  KEY `FK_DASH_IND_DASHBOARD_IDX` (`DASHBOARD_ID`),
  KEY `FK_DASH_IND_INDICATOR_IDX` (`INDICATOR_ID`),
  CONSTRAINT `FK_DASH_IND_DASHBOARD` FOREIGN KEY (`DASHBOARD_ID`) REFERENCES `DASHBOARD` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_DASH_IND_INDICATOR` FOREIGN KEY (`INDICATOR_ID`) REFERENCES `INDICATOR` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-------------------------------------------------------------
-- SERIE Table
-------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.`SERIE` (
  `ID` MEDIUMINT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column',
  `DESCRIPTION` VARCHAR(4000) COLLATE UTF8_BIN COMMENT 'The serie description',
  `INDICATOR_ID` MEDIUMINT(10) NOT NULL COMMENT 'The parent indicator ID',
  `UNIT_NAME` VARCHAR(500) COLLATE UTF8_BIN COMMENT 'The serie data unit name',
  `VALUE_FIELD` VARCHAR(200) COLLATE UTF8_BIN COMMENT 'The field that has the value for this sirie',
  `TYPE` ENUM('A','B','C','L','P') NOT NULL DEFAULT 'C' COLLATE UTF8_BIN COMMENT 'The serie type',
  PRIMARY KEY (`ID`),
  KEY `FK_SERIE_INDICATOR_IDX` (`INDICATOR_ID`),
  CONSTRAINT `FK_SERIE_INDICATOR` FOREIGN KEY (`INDICATOR_ID`) REFERENCES `INDICATOR` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-------------------------------------------------------------
-- FILTER Table
-------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.`FILTER` (
  `ID` MEDIUMINT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column',
  `UNIQUE_ID` VARCHAR(200) COLLATE UTF8_BIN NOT NULL COMMENT 'Business unique ID',
  `TITLE` VARCHAR(500) COLLATE UTF8_BIN NOT NULL COMMENT 'The filter title',
  `DESCRIPTION` VARCHAR(4000) COLLATE UTF8_BIN NOT NULL COMMENT 'The filter description',
  `BIND_TO_PROFILE` VARCHAR(100) COLLATE UTF8_BIN COMMENT 'The profile to bind this filter to (auto-apply filter to profile users)',
  `TYPE` ENUM('B','D','L','N','T') DEFAULT 'T' NOT NULL COLLATE UTF8_BIN NOT NULL COMMENT 'The filter type',
  `DEFAULT_VALUE` VARCHAR(500) COLLATE UTF8_BIN COMMENT 'The default filter value',
  `SQL_TEMPLATE` VARCHAR(4000) COLLATE UTF8_BIN COMMENT 'The SQL template to apply to the indicator query when the filter is used',
  `ITEMS_QUERY_SQL` VARCHAR(4000) COLLATE UTF8_BIN COMMENT 'The LOV SQL query',
  `ITEMS_LIST` VARCHAR(4000) COLLATE UTF8_BIN COMMENT 'The LOV values',
  `INDICATOR_ID` MEDIUMINT(10) NOT NULL COMMENT 'The parent indicator ID',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `FILTER_UNIQUE_ID_UK` (`UNIQUE_ID`),
  KEY `FK_FILTER_INDICATOR_IDX` (`INDICATOR_ID`),
  CONSTRAINT `FK_FILTER_INDICATOR` FOREIGN KEY (`INDICATOR_ID`) REFERENCES `INDICATOR` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$
