DELIMITER $$

-- -----------------------------------------------------------
-- REPORT TEMPLATE Table
-- -----------------------------------------------------------
CREATE TABLE IF NOT EXISTS DIF.REPORT_TEMPLATE
(
	ID               INT(10) NOT NULL AUTO_INCREMENT COMMENT 'Unique identifier for PK',
	NAME             VARCHAR(200) NOT NULL COMMENT 'The report name',
	DESCRIPTION      VARCHAR(2000) COMMENT 'the report description',
	TYPE             ENUM('JR','FM') NOT NULL COMMENT 'the report type',
	ENABLED          TINYINT(1) NOT NULL COMMENT 'is the report enabled',
	TEMPLATE_URL     VARCHAR(2000) NOT NULL COMMENT 'the report template URL',
	TEMPLATE_FILES   BLOB COMMENT 'zip file with the report template and it''s assets',
	CONTEXT_CLASS_ID VARCHAR(100) COMMENT 'the id of the context class implementation to provide resources and rules to this report',
 	PRIMARY KEY (`ID`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-- -----------------------------------------------------------
-- REPORT template areas Table
-- -----------------------------------------------------------
CREATE TABLE IF NOT EXISTS DIF.REPORT_TEMPLATE_AREA
(
	ID                  INT(10) NOT NULL AUTO_INCREMENT COMMENT 'Unique identifier for PK',
	REPORT_TEMPLATE_ID  INT(10) NOT NULL COMMENT 'The parent template ID',
	TITLE               VARCHAR(200) NOT NULL COMMENT 'The area title',
	SHOW_TITLE          TINYINT(1) NOT NULL COMMENT 'if true show the area title', 
	POSITION            INT(3) NOT NULL COMMENT 'the position of this area in the template', 
	CONTENT             LONGTEXT NOT NULL COMMENT 'the content', 
	PRIVATE             TINYINT(1) NOT NULL COMMENT 'is the area is private', 
	CUSTOMIZABLE        TINYINT(1) NOT NULL COMMENT 'if the area is customizable in the report instance', 
	MANDATORY           TINYINT(1) NOT NULL COMMENT 'if the area is mandatory in the report instance', 
	TYPE                ENUM('HTML','CHART', 'FM') NOT NULL COMMENT 'the area type', 
	INDICATOR_ID        mediumint(10) COMMENT 'the indicator id for Chart typed areas', 
	LANGUAGE            VARCHAR(2) COMMENT 'the area content language for jasper areas to take into account when calculating the area context objects that the jasper template uses', 
	MAX_SIZE            INT(6) COMMENT 'the content max size for html typed areas',
 	PRIMARY KEY (`ID`),
 	CONSTRAINT `FK_REPORT_TEMPLATE_AREA`
    	FOREIGN KEY (`REPORT_TEMPLATE_ID` )
    	REFERENCES DIF.REPORT_TEMPLATE (`ID` )
    	ON DELETE CASCADE
    	ON UPDATE NO ACTION,
 	CONSTRAINT `FK_REPORT_AREA_INDICATOR`
    	FOREIGN KEY (`INDICATOR_ID` )
    	REFERENCES DIF.INDICATOR (`ID` )
    	ON DELETE NO ACTION
    	ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-- -----------------------------------------------------------
-- REPORT template areas translations
-- -----------------------------------------------------------
CREATE TABLE IF NOT EXISTS DIF.REPORT_TEMPLATE_AREA_TRANS
(
	ID                   INT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column', 
    REPORT_AREA_ID       INT(10) NOT NULL COMMENT 'The area title', 
    LANGUAGE             VARCHAR(2) COMMENT 'The parent area ID', 
    CONTENT              LONGTEXT NOT NULL COMMENT 'the language', 
    TITLE                VARCHAR(200) NOT NULL COMMENT 'the content',
 	PRIMARY KEY (`ID`),
 	UNIQUE INDEX `REPORT_TEMPLATE_AREA_TRANS_UK` (`REPORT_AREA_ID` ASC, `LANGUAGE` ASC) ,
   	CONSTRAINT `FK_REPORT_AREA_TRANS_AREA`
    	FOREIGN KEY (`REPORT_AREA_ID` )
    	REFERENCES DIF.REPORT_TEMPLATE_AREA (`ID` )
    	ON DELETE CASCADE
    	ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-- -----------------------------------------------------------
-- SQL DataSources
-- -----------------------------------------------------------
CREATE TABLE IF NOT EXISTS DIF.SQL_DATA_SOURCE
(
	ID                   INT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column', 
    NAME                 VARCHAR(100) NOT NULL COMMENT 'Name of the data source', 
    URL                  VARCHAR(500) NOT NULL COMMENT 'URL to connect', 
    USER_NAME            VARCHAR(100) NOT NULL COMMENT 'User name to connect', 
    PASSWORD             VARCHAR(100) NOT NULL COMMENT 'Password to connect',
    DIALECT              VARCHAR(100) NOT NULL COMMENT 'the database dialect',
 	PRIMARY KEY (`ID`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-- -----------------------------------------------------------
-- REPORT template areas sql definitions
-- -----------------------------------------------------------
CREATE TABLE IF NOT EXISTS DIF.REPORT_TEMPLATE_AREA_SQL
(
	ID                   INT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column', 
    NAME                 VARCHAR(100) NOT NULL COMMENT 'The sql business name', 
    REPORT_AREA_ID       INT(10) NOT NULL COMMENT 'the report area ID', 
    SQL_DATA_SOURCE_ID   INT(10) COMMENT 'the data source ID', 
    `SQL`                  LONGTEXT NOT NULL COMMENT 'the SQL query',
 	PRIMARY KEY (`ID`),
 	CONSTRAINT `FK_REPORT_AREA_SQL_AREA`
    	FOREIGN KEY (`REPORT_AREA_ID` )
    	REFERENCES DIF.REPORT_TEMPLATE_AREA (`ID` )
    	ON DELETE CASCADE
    	ON UPDATE NO ACTION,
 	CONSTRAINT `FK_REPORT_AREA_SQL_DS`
    	FOREIGN KEY (`SQL_DATA_SOURCE_ID` )
    	REFERENCES DIF.SQL_DATA_SOURCE (`ID` )
    	ON DELETE NO ACTION
    	ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$


-- -----------------------------------------------------------
-- REPORT instance
-- -----------------------------------------------------------
CREATE TABLE IF NOT EXISTS DIF.REPORT_INSTANCE
(
	ID                   INT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column', 
    REPORT_TEMPLATE_ID   INT(10) NOT NULL COMMENT 'The parent template ID', 
    TITLE                VARCHAR(200) NOT NULL COMMENT 'The instance business title', 
    READONLY             TINYINT(1) NOT NULL COMMENT 'if true this instance if readonly and cannot be changed', 
    BUSINESS_KEY         VARCHAR(500) COMMENT 'the business key this instance is associated to', 
    DOCUMENT_ID          INT COMMENT 'the generated report file (document repository ID)',
 	PRIMARY KEY (`ID`),
 	CONSTRAINT `FK_REPORT_INSTANCE`
    	FOREIGN KEY (`REPORT_TEMPLATE_ID` )
    	REFERENCES DIF.REPORT_TEMPLATE (`ID` )
    	ON DELETE NO ACTION
    	ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-- -----------------------------------------------------------
-- REPORT instance areas Table
-- -----------------------------------------------------------
CREATE TABLE IF NOT EXISTS DIF.REPORT_INSTANCE_AREA
(
	ID                      INT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column', 
    REPORT_INSTANCE_ID      INT(10) NOT NULL COMMENT 'The parent report ID', 
    REPORT_TEMPLATE_AREA_ID INT(10) NOT NULL COMMENT 'The parent template area ID', 
    TITLE                   VARCHAR(200) NOT NULL COMMENT 'The area title', 
    SHOW_TITLE              TINYINT(1) NOT NULL COMMENT 'if true show the area title', 
    POSITION                INT(3) NOT NULL COMMENT 'the position of this area in the template', 
    CONTENT                 LONGTEXT NOT NULL COMMENT 'the content', 
    PRIVATE                 TINYINT(1) NOT NULL COMMENT 'is the area is private', 
    CUSTOMIZABLE            TINYINT(1) NOT NULL COMMENT 'if the area is customizable in the report instance', 
    MANDATORY               TINYINT(1) NOT NULL COMMENT 'if the area is mandatory in the report instance', 
    TYPE                    ENUM('HTML','CHART', 'FM') NOT NULL COMMENT 'the area type', 
    INDICATOR_ID            mediumint(10) COMMENT 'the indicator id for Chart typed areas', 
    LANGUAGE                VARCHAR(2) COMMENT 'the area content language for jasper areas to take into account when calculating the area context objects that the jasper template uses', 
    MAX_SIZE                INT(6) COMMENT 'the content max size for html typed areas',
 	PRIMARY KEY (`ID`),
 	CONSTRAINT `FK_REPORT_INST_AREA_REP`
    	FOREIGN KEY (`REPORT_INSTANCE_ID` )
    	REFERENCES DIF.REPORT_INSTANCE (`ID` )
    	ON DELETE CASCADE
    	ON UPDATE NO ACTION,
 	CONSTRAINT `FK_REP_INST_AREA_AREA`
    	FOREIGN KEY (`REPORT_TEMPLATE_AREA_ID` )
    	REFERENCES DIF.REPORT_TEMPLATE_AREA (`ID` )
    	ON DELETE NO ACTION
    	ON UPDATE NO ACTION,
 	CONSTRAINT `FK_REP_INST_AREA_INDICATOR`
    	FOREIGN KEY (`INDICATOR_ID` )
    	REFERENCES DIF.INDICATOR (`ID` )
    	ON DELETE NO ACTION
    	ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-- -----------------------------------------------------------
-- REPORT instance areas translations
-- -----------------------------------------------------------
CREATE TABLE IF NOT EXISTS DIF.REPORT_INSTANCE_AREA_TRANS
(
	ID                      INT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column', 
	REPORT_INSTANCE_AREA_ID INT(10) NOT NULL COMMENT 'Area Title', 
    LANGUAGE                VARCHAR(2) COMMENT 'The parent area ID', 
    CONTENT                 LONGTEXT NOT NULL COMMENT 'the language', 
    TITLE                   VARCHAR(200) NOT NULL COMMENT 'the content',  
 	PRIMARY KEY (`ID`),
 	UNIQUE INDEX `REPORT_INSTANCE_AREA_TRANS_UK` (`REPORT_INSTANCE_AREA_ID` ASC, `LANGUAGE` ASC) ,
 	CONSTRAINT `FK_REP_INST_AREA_TRANS_AREA`
    	FOREIGN KEY (`REPORT_INSTANCE_AREA_ID` )
    	REFERENCES DIF.REPORT_INSTANCE_AREA (`ID` )
    	ON DELETE CASCADE
    	ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-- -----------------------------------------------------------
-- REPORT instance areas sql definitions
-- -----------------------------------------------------------
CREATE TABLE IF NOT EXISTS DIF.REPORT_INSTANCE_AREA_SQL
(
	ID                      INT(10) NOT NULL AUTO_INCREMENT COMMENT 'ID column', 
	NAME                      VARCHAR(100) NOT NULL COMMENT 'the sql business name',             
    REPORT_INSTANCE_AREA_ID   INT(10) NOT NULL COMMENT 'the report instance area ID', 
    SQL_DATA_SOURCE_ID        INT(10) COMMENT 'the data source ID', 
    `SQL`                       LONGTEXT NOT NULL COMMENT 'the SQL query',  
 	PRIMARY KEY (`ID`),
 	CONSTRAINT `FK_REP_INST_AREA_SQL_AREA`
    	FOREIGN KEY (`REPORT_INSTANCE_AREA_ID` )
    	REFERENCES DIF.REPORT_INSTANCE_AREA (`ID` )
    	ON DELETE CASCADE
    	ON UPDATE NO ACTION,
 	CONSTRAINT `FK_REP_INST_AREA_SQL_DS`
    	FOREIGN KEY (`SQL_DATA_SOURCE_ID` )
    	REFERENCES DIF.SQL_DATA_SOURCE (`ID` )
    	ON DELETE NO ACTION
    	ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$