DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'AUDIT_LOG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.AUDIT_LOG( '||
      '  id              number not null, '||
      '  app             varchar2(30) not null, '||
      '  userid          varchar2(100) not null, '||
      '  entity_name     varchar2(200) not null, '||
      '  operation       char(1) not null, '||
      '  operation_date  date not null, '||
      '  instance_id     varchar2(200) '||
      ') ';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'AUDIT_LOG'
  AND    CONSTRAINT_NAME = 'AUDIT_LOG_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.AUDIT_LOG ADD CONSTRAINT AUDIT_LOG_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'AUDIT_LOG'
  AND    CONSTRAINT_NAME = 'AUDIT_LOG_OPER_CK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'alter table DIF.AUDIT_LOG add constraint AUDIT_LOG_OPER_CK check (operation in (''C'',''U'',''D''))';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_AUDIT_LOG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_AUDIT_LOG MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.AUDIT_LOG.id is 'The primary key';
comment on column DIF.AUDIT_LOG.app is 'The application name';
comment on column DIF.AUDIT_LOG.userid is 'The user ID';
comment on column DIF.AUDIT_LOG.entity_name is 'The entity (table) name changed';
comment on column DIF.AUDIT_LOG.operation is 'The issued operation ';
comment on column DIF.AUDIT_LOG.operation_date is 'The date the operation took place';
comment on column DIF.AUDIT_LOG.instance_id is 'The instance ID (PK) of the operation';

-- Create/Recreate indexes
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER           = 'DIF'
  AND    INDEX_NAME      = 'AUDIT_LOG_ENTITY';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'create index DIF.AUDIT_LOG_ENTITY on DIF.AUDIT_LOG (entity_name, operation_date)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER           = 'DIF'
  AND    INDEX_NAME      = 'AUDIT_LOG_DATE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'create index DIF.AUDIT_LOG_DATE on DIF.AUDIT_LOG (operation_date, entity_name)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER           = 'DIF'
  AND    INDEX_NAME      = 'AUDIT_LOG_APP';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'create index DIF.AUDIT_LOG on DIF.AUDIT_LOG (app, entity_name, operation_date)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'AUDIT_LOG_DETAIL';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.AUDIT_LOG_DETAIL( '||
      '  id             number not null, '||
      '  audit_log_id   number not null, '||
      '  column_name    varchar2(200) not null, '||
      '  previous_value varchar2(4000), '||
      '  new_value      varchar2(4000) '||
      ') ';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'AUDIT_LOG_DETAIL'
  AND    CONSTRAINT_NAME = 'AUDIT_LOG_DETAIL_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.AUDIT_LOG_DETAIL ADD CONSTRAINT AUDIT_LOG_DETAIL_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'AUDIT_LOG_DETAIL'
  AND    CONSTRAINT_NAME = 'AUDIT_LOG_DETAIL_LOG_FK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.AUDIT_LOG_DETAIL ADD CONSTRAINT AUDIT_LOG_DETAIL_LOG_FK foreign key (AUDIT_LOG_ID) references DIF.audit_log (ID) on delete cascade';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_AUDIT_LOG_DETAIL';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_AUDIT_LOG_DETAIL MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.AUDIT_LOG_DETAIL.id is 'The primary key';
comment on column DIF.AUDIT_LOG_DETAIL.audit_log_id is 'The audit log main entry id';
comment on column DIF.AUDIT_LOG_DETAIL.column_name is 'The changed column name in the operation';
comment on column DIF.AUDIT_LOG_DETAIL.previous_value is 'The previous value';
comment on column DIF.AUDIT_LOG_DETAIL.new_value is 'The new value';
