/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl;

import java.util.List;
import org.hibernate.cfg.Configuration;
import pt.digitalis.dif.controller.security.managers.IAuthorizationManager;
import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.ecommerce.IECommerce;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.utils.AbstractModelManager;
import pt.digitalis.dif.startup.DIFGeneralConfigurationParameters;

public class DIFRepositoryDBModelManager
extends AbstractModelManager {
    public static String MODEL_ID = "DIF";
    private Boolean enabled = null;

    public Configuration getConfiguration() {
        return DIFRepositoryFactory.getConfiguration();
    }

    public Boolean getDeclareJavaLocation() {
        return true;
    }

    public String getFactoryName() {
        return DIFRepositoryFactory.SESSION_FACTORY_NAME;
    }

    public String getSchema() {
        return "DIF";
    }

    protected boolean isEnabledInternal() throws InternalFrameworkException {
        boolean hibernateConnectionConfigured = this.initializeWithDefaultApplicationConfiguration();
        if (this.enabled == null) {
            IAuthorizationManager authorizationManager = (IAuthorizationManager)DIFIoCRegistry.getRegistry().getImplementation(IAuthorizationManager.class, "Database");
            IMessageManager messageManager = (IMessageManager)DIFIoCRegistry.getRegistry().getImplementation(IMessageManager.class, "Database");
            IIdentityManager identityManager = (IIdentityManager)DIFIoCRegistry.getRegistry().getImplementation(IIdentityManager.class, "Database");
            List eCommerce = DIFIoCRegistry.getRegistry().getImplementations(IECommerce.class);
            String poolsPersistConfig = DIFGeneralConfigurationParameters.getInstance().getPersistPools();
            boolean poolsDatabasePersistance = "Y".equalsIgnoreCase(poolsPersistConfig) || "D".equalsIgnoreCase(poolsPersistConfig) && hibernateConnectionConfigured;
            String formsPersistConfig = DIFGeneralConfigurationParameters.getInstance().getCustomForms();
            boolean formsDatabasePersistance = "Y".equalsIgnoreCase(formsPersistConfig) || "D".equalsIgnoreCase(formsPersistConfig) && hibernateConnectionConfigured;
            this.enabled = eCommerce.size() > 0 || authorizationManager != null || messageManager != null || identityManager != null || poolsDatabasePersistance || formsDatabasePersistance;
        }
        if (this.enabled.booleanValue() && !hibernateConnectionConfigured) {
            throw new InternalFrameworkException("The dif-database-repository hibernate configurations are not correctly configured! Please configure the database access configuration (Ex: url, user, password) and run this process again.", null);
        }
        return this.enabled;
    }
}

