package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentTrans;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class DataConsentTrans.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.DataConsentTrans
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoDataConsentTransDAO extends IHibernateDAO<DataConsentTrans> {

    /**
     * Obtains a new DataSet for the DataConsentTrans entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DataConsentTrans> getDataConsentTransDataSet();

	/**
	 * Persist a DataConsentTrans object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(DataConsentTrans transientInstance);

	/**
	 * Updates a modified DataConsentTrans in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(DataConsentTrans instance);

	/**
	 * Attach an unmodified DataConsentTrans instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(DataConsentTrans instance);

	/**
	 * Removes a DataConsentTrans instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(DataConsentTrans persistentInstance);

	/**
	 * Merge a DataConsentTrans instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public DataConsentTrans merge(DataConsentTrans detachedInstance);

	/**
	 * Finds a DataConsentTrans instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public DataConsentTrans findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all DataConsentTrans instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<DataConsentTrans> findAll();


	/**
	 * Gets a {@link List} of all DataConsentTrans instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentTrans> findByFieldParcial(DataConsentTrans.Fields field, String value);

	/**
	 * Gets a {@link List} of all DataConsentTrans instances
	 * in the persistence layer than match the languageId attribute with the given value
	 *
	 * @param languageId to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentTrans> findByLanguageId(String languageId);

	/**
	 * Gets a {@link List} of all DataConsentTrans instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentTrans> findByTitle(String title);

	/**
	 * Gets a {@link List} of all DataConsentTrans instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentTrans> findByDescription(String description);
}
