package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.Manager;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class Manager.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Manager
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoManagerDAO extends IHibernateDAO<Manager> {

    /**
     * Obtains a new DataSet for the Manager entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Manager> getManagerDataSet();

	/**
	 * Persist a Manager object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Manager transientInstance);

	/**
	 * Updates a modified Manager in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Manager instance);

	/**
	 * Attach an unmodified Manager instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Manager instance);

	/**
	 * Removes a Manager instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Manager persistentInstance);

	/**
	 * Merge a Manager instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Manager merge(Manager detachedInstance);

	/**
	 * Finds a Manager instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Manager findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all Manager instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<Manager> findAll();


	/**
	 * Gets a {@link List} of all Manager instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<Manager> findByFieldParcial(Manager.Fields field, String value);

	/**
	 * Gets a {@link List} of all Manager instances
	 * in the persistence layer than match the uniqueId attribute with the given value
	 *
	 * @param uniqueId to match
	 * @return the {@link List} of instances
	 */
    public List<Manager> findByUniqueId(String uniqueId);
}
