package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceAreaTrans;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class ReportInstanceAreaTrans.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceAreaTrans
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoReportInstanceAreaTransDAO extends IHibernateDAO<ReportInstanceAreaTrans> {

    /**
     * Obtains a new DataSet for the ReportInstanceAreaTrans entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportInstanceAreaTrans> getReportInstanceAreaTransDataSet();

	/**
	 * Persist a ReportInstanceAreaTrans object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportInstanceAreaTrans transientInstance);

	/**
	 * Updates a modified ReportInstanceAreaTrans in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportInstanceAreaTrans instance);

	/**
	 * Attach an unmodified ReportInstanceAreaTrans instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportInstanceAreaTrans instance);

	/**
	 * Removes a ReportInstanceAreaTrans instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportInstanceAreaTrans persistentInstance);

	/**
	 * Merge a ReportInstanceAreaTrans instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportInstanceAreaTrans merge(ReportInstanceAreaTrans detachedInstance);

	/**
	 * Finds a ReportInstanceAreaTrans instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportInstanceAreaTrans findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all ReportInstanceAreaTrans instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceAreaTrans> findAll();


	/**
	 * Gets a {@link List} of all ReportInstanceAreaTrans instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceAreaTrans> findByFieldParcial(ReportInstanceAreaTrans.Fields field, String value);

	/**
	 * Gets a {@link List} of all ReportInstanceAreaTrans instances
	 * in the persistence layer than match the language attribute with the given value
	 *
	 * @param language to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceAreaTrans> findByLanguage(String language);

	/**
	 * Gets a {@link List} of all ReportInstanceAreaTrans instances
	 * in the persistence layer than match the content attribute with the given value
	 *
	 * @param content to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceAreaTrans> findByContent(String content);

	/**
	 * Gets a {@link List} of all ReportInstanceAreaTrans instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceAreaTrans> findByTitle(String title);
}
