package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.CustomMessages;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoCustomMessagesDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class CustomMessages.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.CustomMessages
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoCustomMessagesDAOImpl implements IAutoCustomMessagesDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the CustomMessages entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<CustomMessages> getCustomMessagesDataSet()
    {
        return new HibernateDataSet<CustomMessages>(CustomMessages.class, this, CustomMessages.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoCustomMessagesDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a CustomMessages object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(CustomMessages transientInstance) {
        logger.debug("persisting CustomMessages instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified CustomMessages in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(CustomMessages instance) {
        logger.debug("attaching dirty CustomMessages instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified CustomMessages instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(CustomMessages instance) {
        logger.debug("attaching clean CustomMessages instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a CustomMessages instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(CustomMessages persistentInstance) {
        logger.debug("deleting CustomMessages instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a CustomMessages instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public CustomMessages merge(CustomMessages detachedInstance) {
        logger.debug("merging CustomMessages instance");
        CustomMessages result = (CustomMessages) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a CustomMessages instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public CustomMessages findById( java.lang.Long id) {
        logger.debug("getting CustomMessages instance with id: " + id);
        CustomMessages instance = (CustomMessages) getSession()
                .get(CustomMessages.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all CustomMessages instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<CustomMessages> findAll() {

 		List<CustomMessages> instances = new ArrayList<CustomMessages>();
		logger.debug("getting all CustomMessages instances");
        instances = getSession().createCriteria(CustomMessages.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<CustomMessages>) instances;
    }


	/**
	 * Gets a {@link List} of all CustomMessages instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<CustomMessages> findByExample(CustomMessages instance) {
        logger.debug("finding CustomMessages instance by example");
        List<CustomMessages> results = (List<CustomMessages>) getSession()
                .createCriteria(CustomMessages.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all CustomMessages instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<CustomMessages> findByFieldParcial(CustomMessages.Fields field, String value) {
        logger.debug("finding CustomMessages instance by parcial value: "+field+" like "+value);
        List<CustomMessages> results = (List<CustomMessages>) getSession()
                .createCriteria(CustomMessages.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all CustomMessages instances
	 * in the persistence layer than match the messageId attribute with the given value
	 *
	 * @param messageId to match
	 * @return the {@link List} of instances
	 */
    public List<CustomMessages> findByMessageId(String messageId) {
        CustomMessages instance = new CustomMessages();

        instance.setMessageId(messageId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all CustomMessages instances
	 * in the persistence layer than match the message attribute with the given value
	 *
	 * @param message to match
	 * @return the {@link List} of instances
	 */
    public List<CustomMessages> findByMessage(String message) {
        CustomMessages instance = new CustomMessages();

        instance.setMessage(message);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all CustomMessages instances
	 * in the persistence layer than match the entityId attribute with the given value
	 *
	 * @param entityId to match
	 * @return the {@link List} of instances
	 */
    public List<CustomMessages> findByEntityId(String entityId) {
        CustomMessages instance = new CustomMessages();

        instance.setEntityId(entityId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all CustomMessages instances
	 * in the persistence layer than match the language attribute with the given value
	 *
	 * @param language to match
	 * @return the {@link List} of instances
	 */
    public List<CustomMessages> findByLanguage(String language) {
        CustomMessages instance = new CustomMessages();

        instance.setLanguage(language);

        return findByExample(instance);
    }

}

