package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentReview;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoDataConsentReviewDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class DataConsentReview.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.DataConsentReview
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoDataConsentReviewDAOImpl implements IAutoDataConsentReviewDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the DataConsentReview entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DataConsentReview> getDataConsentReviewDataSet()
    {
        return new HibernateDataSet<DataConsentReview>(DataConsentReview.class, this, DataConsentReview.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoDataConsentReviewDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a DataConsentReview object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(DataConsentReview transientInstance) {
        logger.debug("persisting DataConsentReview instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified DataConsentReview in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(DataConsentReview instance) {
        logger.debug("attaching dirty DataConsentReview instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified DataConsentReview instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(DataConsentReview instance) {
        logger.debug("attaching clean DataConsentReview instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a DataConsentReview instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(DataConsentReview persistentInstance) {
        logger.debug("deleting DataConsentReview instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a DataConsentReview instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public DataConsentReview merge(DataConsentReview detachedInstance) {
        logger.debug("merging DataConsentReview instance");
        DataConsentReview result = (DataConsentReview) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a DataConsentReview instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public DataConsentReview findById( java.lang.Long id) {
        logger.debug("getting DataConsentReview instance with id: " + id);
        DataConsentReview instance = (DataConsentReview) getSession()
                .get(DataConsentReview.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all DataConsentReview instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<DataConsentReview> findAll() {

 		List<DataConsentReview> instances = new ArrayList<DataConsentReview>();
		logger.debug("getting all DataConsentReview instances");
        instances = getSession().createCriteria(DataConsentReview.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<DataConsentReview>) instances;
    }


	/**
	 * Gets a {@link List} of all DataConsentReview instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<DataConsentReview> findByExample(DataConsentReview instance) {
        logger.debug("finding DataConsentReview instance by example");
        List<DataConsentReview> results = (List<DataConsentReview>) getSession()
                .createCriteria(DataConsentReview.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all DataConsentReview instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<DataConsentReview> findByFieldParcial(DataConsentReview.Fields field, String value) {
        logger.debug("finding DataConsentReview instance by parcial value: "+field+" like "+value);
        List<DataConsentReview> results = (List<DataConsentReview>) getSession()
                .createCriteria(DataConsentReview.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all DataConsentReview instances
	 * in the persistence layer than match the lastReviewDate attribute with the given value
	 *
	 * @param lastReviewDate to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentReview> findByLastReviewDate(Timestamp lastReviewDate) {
        DataConsentReview instance = new DataConsentReview();

        instance.setLastReviewDate(lastReviewDate);

        return findByExample(instance);
    }

}

